% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffvariance.test.R
\name{diffvariance.test}
\alias{diffvariance.test}
\title{Two Sample Variance Test of Normal Populations}
\usage{
diffvariance.test(x1 = NULL, x2 = NULL, s1 = NULL, s2 = NULL,
  sc1 = NULL, sc2 = NULL, smu1 = NULL, smu2 = NULL, mu1 = NULL,
  mu2 = NULL, n1 = NULL, n2 = NULL, alternative = "two.sided",
  alpha = 0.05, plot = TRUE, lwd = 1)
}
\arguments{
\item{x1}{a numeric vector containing the sample of one population.}

\item{x2}{a numeric vector containing the sample of the other population.}

\item{s1}{a single numeric value corresponding with the sample standard deviation of the first sample.}

\item{s2}{a single numeric value corresponding with the sample standard deviation of the second sample.}

\item{sc1}{a single numeric value corresponding with the cuasi-standard deviation of the first sample.}

\item{sc2}{a single numeric value corresponding with the cuasi-standard deviation of the second sample.}

\item{smu1}{if known, a single numeric value corresponding with the estimation of the standard deviation of the first sample.}

\item{smu2}{if known, a single numeric value corresponding with the estimation of the standard deviation of the second sample.}

\item{mu1}{if known, a single numeric  corresponding with the mean of one population.}

\item{mu2}{if known, a single numeric value corresponding with the mean of the other population.}

\item{n1}{a single number indicating the sample size of \code{x1}. By default length of
argument \code{x1}.}

\item{n2}{a single number indicating the sample size of \code{x2}. By default length of
argument \code{x2}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one
of "\code{two.sided}" (default), "\code{greater}" or "\code{less}".}

\item{alpha}{single number between 0 and 1, significance level.}

\item{plot}{a logical value indicating whether to display a graph including the test statistic value for the sample, its distribution, the rejection region and p-value.}

\item{lwd}{single number indicating the line width of the plot.}
}
\value{
A list with class "\code{lstest}" and "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of the freedom of the F distribution of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the ratio of the cuasi-variances of \code{x1} and \code{x2}.}
\item{null.value}{the value specified by the null.}
\item{alternative}{a character string describing the alternative.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
\item{alpha}{the significance level.}
\item{dist.name}{a character string indicating the distribution of the test statistic.}
\item{statformula}{a character string with the statistic's formula.}
\item{reject.region}{a character string with the reject region.}
}
\description{
\code{diffvariance.test} allows to compute hypothesis tests about two population variances in both scenarios: known and unknown population mean.
}
\details{
The formula interface is applicable when the user provides the sample(s) or values
of the sample characteristics (cuasi-standard deviation or sample standard deviation).
When \code{mu1} and \code{mu2} or \code{smu1} and \code{smu2} are provided, the function performs
the procedure with known population means.
}
\examples{
x1 <- rnorm(40, mean = 1, sd = 2)
x2 <- rnorm(60, mean = 2, sd = 1.5)
# unknown population mean
diffvariance.test(x1, x2)
diffvariance.test(x1, sc2 = sd(x2), n2 = length(x2))
diffvariance.test(sc1 = sd(x1), sc2 = sd(x2), n1 = length(x1), n2 = length(x2))
# known population mean
diffvariance.test(x1, x2, mu1 = 1, mu2 = 2)
smu1 <- Smu(x1, mu = 1); smu2 <- Smu(x2, mu = 2)
diffvariance.test(smu1 = smu1, smu2 = smu2, n1 = length(x1), n2 = length(x2))
}
