% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.landmark.R
\name{plot.landmark}
\alias{plot.landmark}
\title{Create a calibration plot}
\usage{
\method{plot}{landmark}(x, x_L, n, x_lims, y_lims, ...)
}
\arguments{
\item{x}{Object inheriting the class \code{landmark}, this should be the output from either \code{fit_LME_landmark_model} or \code{fit_LOCF_landmark_model}. It should contain a list
of landmark models corresponding to different landmark times \code{x_L}.}

\item{x_L}{Numeric specifying the landmark time. This indicates which landmark model in \code{x} to use.}

\item{n}{Numeric specifying the number of bins to use.}

\item{x_lims}{Vector of length 2 specifying the limits of the x axes}

\item{y_lims}{Vector of length 2 specifying the limits of the y axes}

\item{\dots}{Arguments passed to \code{ggplot2::labs} to modify axis, legend, and plot labels}
}
\value{
Calibration plot showing the value of predicted probabilities against observed frequencies, with a \code{y=x} line.
}
\description{
Creates a calibration plot for the landmark model fitted by \code{fit_LME_landmark_model} or \code{fit_LOCF_landmark_model}.
This function plots the observed frequencies of the event of interest against the predicted probabilities of the event of interest.
}
\details{
This function bins the predicted probabilities of the event of interest into \code{n} bins. The event of interest is the event with
\code{event_status=1} when fitting the landmark model. For each of the \code{n} sets of individuals, the Aalen-Johansen estimator is fit to that set
and used to calculate the risk of an event at the horizon time. The predictions (from the landmark model) and the observed frequencies
(from the Aalen-Johansen estimator) are plotted against each other. For a perfect prediction model, the points will be plotted along the y=x line.
}
\examples{
library(Landmarking)
data(data_repeat_outcomes)
data_model_landmark_LOCF <-
  fit_LOCF_landmark(
    data_long = data_repeat_outcomes,
    x_L = c(60, 61),
    x_hor = c(65, 66),
    covariates =
      c("ethnicity", "smoking", "diabetes", "sbp_stnd", "tchdl_stnd"),
    covariates_time =
      c(rep("response_time_sbp_stnd", 4), "response_time_tchdl_stnd"),
    k = 10,
    individual_id = "id",
    event_time = "event_time",
    event_status = "event_status",
    survival_submodel = "cause_specific"
  )
 plot(x=data_model_landmark_LOCF,x_L=60,n=5)
 plot(x=data_model_landmark_LOCF,x_L=61,n=5)
}
