% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model_assessment.R
\name{get_model_assessment}
\alias{get_model_assessment}
\title{Compute C-index and Brier score}
\usage{
get_model_assessment(
  data,
  individual_id,
  event_prediction,
  event_status,
  event_time,
  x_hor,
  b
)
}
\arguments{
\item{data}{Data frame containing survival outcomes and the event predictions from the model,
there should be one row for each individual}

\item{individual_id}{Character string specifying the column name in \code{data} which contains the individual identifiers}

\item{event_prediction}{Character string specifying the column name in \code{data} containing the predicted probability of the event of interest}

\item{event_status}{Character string specifying the column name in \code{data} which contains the event status (where 0=censoring, 1=event of interest, if there are competing events these are labelled 2 or above). Events at time \code{x_hor} should be labelled censored.}

\item{event_time}{Character string specifying the column name in \code{data} which contains the event time.}

\item{x_hor}{Numeric specifying the horizon time(s)}

\item{b}{Integer specifying the number of bootstrap samples to take when calcluating standard error of c-index and Brier score}
}
\value{
List containing C-index, Brier score and their standard errors
}
\description{
Performs model assessment by computing the C-index and Brier score at time \code{x_hor}. There is the option
to calculate their standard errors using bootstraping.
}
\details{
There are two factors in assessing the performance of a prediction model; its
discrimination and its calibration. The c-index is a commonly used metric which assesses
discrimination, this refers to the ability of the model to separate individuals into
those that will have an event and those that will not. The c-index at a horizon time \code{x_hor}
looks at the pairs of individuals where one individual has the event at a time T and the other has not had the event at time T.
It is calculated as the proportion of these pairs where their relative risk prediction agrees with the
actual outcomes for the two individuals. This is extended to the competing risks case
by comparing individuals where one had the event of interest at time T and the other individual either
did not experience the event before this time T or experienced a competing event.

The Brier score gives an indication of the calibration of a model (and its discrimination to an extent), this refers to the agreement between the risk prediction and
the outcome. The Brier score is calculated as the average mean squared error of the predicted risk and the event outcome (where
an event is 1 and not experiencing the event is 0). This is extended to the competing risks case by including the competing risk events as
not experiencing the event.

For both the c-index and Brier score calculations, inverse probability censoring weighting (IPCW) is used to create weights
which account for the occurence of censoring. The censoring model assumes for this function is the Kaplan Meier model, i.e. censoring occurs
independently of covariates.

The c-index is calculated using the \code{cindex} function in package \code{pec}. The Brier score is calculated using
\code{pec} function in package \code{pec}.
}
\examples{
\dontrun{
library(Landmarking)
data(data_repeat_outcomes)
data_model_landmark_LOCF <-
  fit_LOCF_landmark(
    data_long = data_repeat_outcomes,
    x_L = c(60, 61),
    x_hor = c(65, 66),
    covariates =
      c("ethnicity", "smoking", "diabetes", "sbp_stnd", "tchdl_stnd"),
    covariates_time =
      c(rep("response_time_sbp_stnd", 4), "response_time_tchdl_stnd"),
    k = 10,
    individual_id = "id",
    event_time = "event_time",
    event_status = "event_status",
    survival_submodel = "cause_specific"
  )
get_model_assessment(data = data_model_landmark_LOCF[["60"]]$data,
  individual_id = "id",
  event_prediction = "event_prediction",
  event_status = "event_status",
  event_time = "event_time",
  x_hor = 65,
  b = 10)}
}
\author{
Isobel Barrott \email{isobel.barrott@gmail.com}
}
