% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlswpspec.R
\name{plot.LSWPspec}
\alias{plot.LSWPspec}
\title{Plot for Objects of Class LSWPspec}
\usage{
\method{plot}{LSWPspec}(x, y, ...)
}
\arguments{
\item{x}{an object of class lswpspec.}

\item{y}{not used, is set to \code{NULL}.}

\item{...}{not currently used.}
}
\value{
A plot of the time-varying spectral estimates.
}
\description{
\code{plot.LSWPspec} returns the plot for objects of class \code{"LSWPspec"}, typically (but not exclusively) a wavelet packet spectral estimate.
}
\details{
This function implements the \code{plot} method for objects of class \code{"LSWPspec"}. It is mainly used to plot spectral estimates returned by \code{LSWPspec}.
The label of the vertical axis uses the wavelet packet basis index notation \code{p = 1,2,...,|b|}, where |b| is the number of packets in a wavelet
packet basis as defined in Cardinali and Nason (2017). The label of the horizontal axis is the time index.
}
\examples{

 wb <- get.wavelet.basis(4)
wpp <- LSWPspec(x = sp500, lev = 4, bb = wb, wavelet = 'la8', smooth = TRUE, spa = 0.35)
       plot(wpp)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{LSWPspec}}, \code{\link{LSWPbasis}}
}
\author{
Alessandro Cardinali
}
