% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load.LSTM}
\alias{load.LSTM}
\title{Load the pre-trained Long Short Term Memory (LSTM) Network}
\usage{
load.LSTM()
}
\value{
An ONNX runtime inference session object for the LSTM model.
}
\description{
Loads the pre-trained Long Short Term Memory (LSTM) Network form \code{LSTM.onnx}.
The function uses the \code{reticulate} package to import the \code{onnxruntime} Python library
and create an inference session for the model.
}
\note{
Note that Python (suggested >= 3.11) and the libraries \code{numpy} and \code{onnxruntime} are required.

First, please ensure that Python is installed on your computer and that Python is
included in the system's PATH environment variable. If not,
please download and install it from the official website (https://www.python.org/).

If you encounter an error when running this function stating that the \code{numpy} and \code{onnxruntime}
modules are missing:

 \code{Error in py_module_import(module, convert = convert) :}

   \code{ModuleNotFoundError: No module named 'numpy'}

or

 \code{Error in py_module_import(module, convert = convert) :}

   \code{ModuleNotFoundError: No module named 'onnxruntime'}

this means that the \code{numpy} or \code{onnxruntime} library is missing from your Python environment. If you are using Windows or macOS,
please run the command \code{pip install numpy} or \code{pip install onnxruntime} in Command Prompt or Windows PowerShell (Windows), or Terminal (macOS).
If you are using Linux, please ensure that \code{pip} is installed and use the command \code{pip install numpy} or
\code{pip install onnxruntime} to install the missing libraries.
}
\seealso{
\code{\link[LSTMfactors]{LSTM}}
}
