% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_mode.R
\name{enable_structured_output}
\alias{enable_structured_output}
\title{Enable Structured Output (Provider-Agnostic)}
\usage{
enable_structured_output(
  config,
  schema = NULL,
  name = "llmr_schema",
  method = c("auto", "json_mode", "tool_call"),
  strict = TRUE
)
}
\arguments{
\item{config}{An \link{llm_config} object.}

\item{schema}{A named list representing a JSON Schema.
If \code{NULL}, OpenAI-compatible providers enforce a JSON object; Gemini switches
to JSON mime type; Anthropic only injects a tool when a schema is supplied.}

\item{name}{Character. Schema/tool name for providers requiring one. Default "llmr_schema".}

\item{method}{One of c("auto","json_mode","tool_call"). "auto" chooses the best
per provider. You rarely need to change this.}

\item{strict}{Logical. Request strict validation when supported (OpenAI-compatible).}
}
\value{
Modified \code{llm_config}.
}
\description{
Turn on structured output for a model configuration. Supports OpenAI‑compatible
providers (OpenAI, Groq, Together, x.ai, DeepSeek), Anthropic, and Gemini.
}
