% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS_plots.R
\name{plot.TS_fit}
\alias{plot.TS_fit}
\title{Plot an LDATS TS model}
\usage{
\method{plot}{TS_fit}(
  x,
  ...,
  plot_type = "summary",
  interactive = FALSE,
  cols = set_TS_summary_plot_cols(),
  bin_width = 1,
  xname = NULL,
  border = NA,
  selection = "median",
  LDATS = FALSE
)
}
\arguments{
\item{x}{A \code{TS_fit} object of a multinomial time series model fit by
\code{\link{TS}}.}

\item{...}{Additional arguments to be passed to subfunctions. Not currently
used, just retained for alignment with \code{\link[graphics]{plot}}.}

\item{plot_type}{"diagnostic" or "summary".}

\item{interactive}{\code{logical} input, should be code{TRUE} unless
testing.}

\item{cols}{\code{list} of elements used to define the colors for the two
panels of the summary plot, as generated simply using 
\code{\link{set_TS_summary_plot_cols}}. \code{cols} has two elements 
\code{rho} and \code{gamma}, each corresponding to the related panel, 
and each containing default values for entries named \code{cols},
\code{option}, and \code{alpha}. See \code{\link{set_gamma_colors}} and 
\code{\link{set_rho_hist_colors}} for details on usage.}

\item{bin_width}{Width of the bins used in the histograms of the summary 
time series plot, in units of the x-axis (the time variable used to fit 
the model).}

\item{xname}{Label for the x-axis in the summary time series plot. Defaults
to \code{NULL}, which results in usage of the \code{timename} element
of the control list (held in\code{control$TS_control$timename}). To have
no label printed, set \code{xname = ""}.}

\item{border}{Border for the histogram, default is \code{NA}.}

\item{selection}{Indicator of the change points to use in the time series
summary plot. Currently only defined for \code{"median"} and 
\code{"mode"}.}

\item{LDATS}{\code{logical} indicating if the plot is part of a larger 
LDATS plot output.}
}
\value{
\code{NULL}.
}
\description{
Generalization of the \code{\link[graphics]{plot}} function to 
  work on fitted TS model objects (class \code{TS_fit}) returned from 
  \code{\link{TS}}.
}
\examples{
\donttest{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  weights <- document_weights(document_term_table)
  TSmod <- TS(data, gamma ~ 1, nchangepoints = 1, "newmoon", weights)
  plot(TSmod)
}

}
