% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA.R
\name{logLik.LDA_VEM}
\alias{logLik.LDA_VEM}
\title{Calculate the log likelihood of a VEM LDA model fit}
\usage{
\method{logLik}{LDA_VEM}(object, ...)
}
\arguments{
\item{object}{A \code{LDA_VEM}-class object.}

\item{...}{Not used, simply included to maintain method compatibility.}
}
\value{
Log likelihood of the model \code{logLik}, also with \code{df}
  (degrees of freedom) and \code{nobs} (number of observations) values.
}
\description{
Imported but updated calculations from topicmodels package, as
  applied to Latent Dirichlet Allocation fit with Variational Expectation 
  Maximization via \code{\link[topicmodels]{LDA}}.
}
\details{
The number of degrees of freedom is 1 (for alpha) plus the number
  of entries in the document-topic matrix. The number of observations is 
  the number of entries in the document-term matrix.
}
\examples{
  data(rodents)
  lda_data <- rodents$document_term_table
  r_LDA <- LDA_set(lda_data, topics = 2)   
  logLik(r_LDA[[1]])

}
\references{
Buntine, W. 2002. Variational extensions to EM and multinomial PCA. 
  \emph{European Conference on Machine Learning, Lecture Notes in Computer 
  Science} \strong{2430}:23-34. \href{https://link.springer.com/chapter/10.1007/3-540-36755-1_3}{link}.

  Grun B. and K. Hornik. 2011. topicmodels: An R Package for Fitting Topic
  Models. \emph{Journal of Statistical Software} \strong{40}:13.
  \href{https://www.jstatsoft.org/article/view/v040i13}{link}.

  Hoffman, M. D., D. M. Blei, and F. Bach. 2010. Online learning for 
  latent Dirichlet allocation. \emph{Advances in Neural Information 
  Processing Systems} \strong{23}:856-864.
  \href{https://papers.nips.cc/paper/3902-online-learning-for-latent-dirichlet-allocation}{link}.
}
