% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Create heatmap visualization from results}
\usage{
plot_heatmap(
  results,
  output_file = "heatmap.png",
  width = 1200,
  height = 900,
  resolution = 120,
  top_n = 15,
  min_score = 1e-04,
  color_palette = "blues",
  show_entity_types = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{results}{The results to visualize}

\item{output_file}{Filename for the output PNG (default: "heatmap.png")}

\item{width}{Width of the output image (default: 1200)}

\item{height}{Height of the output image (default: 900)}

\item{resolution}{Resolution of the output image (default: 120)}

\item{top_n}{Maximum number of results to include (default: 15)}

\item{min_score}{Minimum score threshold (default: 0.0001)}

\item{color_palette}{Color palette for the heatmap (default: "blues")}

\item{show_entity_types}{Logical; if TRUE, show entity types (default: TRUE)}

\item{verbose}{Logical; if TRUE, print status messages (default: TRUE)}
}
\value{
Invisible NULL (creates a file as a side effect)
}
\description{
This function creates a heatmap visualization from ABC results.
}
