% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternative_models.R
\name{lsi_model}
\alias{lsi_model}
\title{LSI model with enhanced biomedical term filtering and NLP verification}
\usage{
lsi_model(
  term_doc_matrix,
  a_term,
  n_factors = 100,
  n_results = 100,
  enforce_biomedical_terms = TRUE,
  c_term_types = NULL,
  entity_types = NULL,
  validation_function = is_valid_biomedical_entity,
  min_word_length = 3,
  use_nlp = TRUE,
  nlp_threshold = 0.7
)
}
\arguments{
\item{term_doc_matrix}{A term-document matrix.}

\item{a_term}{Character string, the source term (A).}

\item{n_factors}{Number of factors to use in LSI.}

\item{n_results}{Maximum number of results to return.}

\item{enforce_biomedical_terms}{Logical. If TRUE, enforces strict biomedical term filtering.}

\item{c_term_types}{Character vector of entity types allowed for C terms.}

\item{entity_types}{Named vector of entity types (if NULL, will try to detect).}

\item{validation_function}{Function to validate biomedical terms.}

\item{min_word_length}{Minimum word length to include.}

\item{use_nlp}{Logical. If TRUE, uses NLP-based validation for biomedical terms.}

\item{nlp_threshold}{Numeric between 0 and 1. Minimum confidence for NLP validation.}
}
\value{
A data frame with ranked discovery results.
}
\description{
This function implements an improved LSI model that more rigorously filters out
non-biomedical terms from the results to ensure clinical relevance. It adds
NLP-based validation as an additional layer of filtering.
}
