% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l2e_regression_TF_dist.R
\name{l2e_regression_TF_dist}
\alias{l2e_regression_TF_dist}
\title{L2E trend filtering regression with distance penalization}
\usage{
l2e_regression_TF_dist(
  y,
  X,
  beta,
  tau,
  D,
  k,
  rho = 1,
  max_iter = 100,
  tol = 1e-04,
  Show.Time = TRUE
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix}

\item{beta}{Initial vector of regression coefficients}

\item{tau}{Initial precision estimate}

\item{D}{The fusion matrix}

\item{k}{The number of nonzero entries in D*beta}

\item{rho}{The parameter in the proximal distance algorithm}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}

\item{Show.Time}{Report the computing time}
}
\description{
\code{l2e_regression_TF_dist} performs robust trend filtering regression under the L2 criterion with distance penalty
}
