% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksic_convert.R
\name{ksic_convert}
\alias{ksic_convert}
\title{Convert KSIC Codes}
\usage{
ksic_convert(ksic, from_C, to_C)
}
\arguments{
\item{ksic}{character. A vector of 5-digit KSIC codes to convert (e.g., '10111').}

\item{from_C}{integer. The source KSIC revision (9, 10, or 11).}

\item{to_C}{integer. The target KSIC revision (9, 10, or 11).}
}
\value{
data.frame. A data.frame containing converted KSIC codes and related information. Only convertible codes from the input will be included.
}
\description{
Converts KSIC codes from one revision to another.
}
\examples{
ksic_convert(c("27192", "27195"), from_C = 10, to_C = 11)

ksic_convert(c("27192", "27195"), from_C = 11, to_C = 10)
}
