% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions_JAGSmodel.R
\name{paste_scaling}
\alias{paste_scaling}
\title{Wrap a data element of a linear predictor in scaling syntax}
\usage{
paste_scaling(x, rows, scale_pars, scalemat)
}
\arguments{
\item{x}{vector of character strings; to be scaled, typically matrix columns}

\item{rows}{integer vector; row numbers of the matrix containing the scaling
information}

\item{scale_pars}{matrix containing the scaling information, with columns
"center" and "scale"}

\item{scalemat}{the name of the scaling matrix in the JAGS model
(e.g. "spM_id")}
}
\description{
Identifies if a data element of a linear predictor should be scaled (based
on whether scaling parameters are given) and then calls \code{paste_scale()}.
}
\details{
Calls \code{paste_scale()} on each element of \code{x}.
}
\keyword{internal}
