% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psVCSignal.R
\name{psVCSignal}
\alias{psVCSignal}
\title{Varying-coefficient penalized signal regression using P-splines.}
\usage{
psVCSignal(
  y,
  X,
  x_index,
  t_var,
  Pars = rbind(c(min(x_index), max(x_index), 10, 3, 1, 2), c(min(t_var), max(t_var), 10,
    3, 1, 2)),
  family = "gaussian",
  link = "default",
  m_binomial = 1 + 0 * y,
  wts = 1 + 0 * y,
  r_gamma = 1 + 0 * y,
  X_pred = X,
  t_pred = t_var,
  y_predicted = NULL,
  ridge_adj = 1e-08,
  int = TRUE
)
}
\arguments{
\item{y}{a glm response vector of length \code{m}, usually continuous, binary/bimomial or counts.}

\item{X}{a \code{m} by \code{p1} Signal matrix of regressors.}

\item{x_index}{\code{p1}-vector for index of Signal (e.g. wavelength).}

\item{t_var}{\code{p2}-vector with other (indexing) variable in coefficient surface (e.g. temperature, depth, time).}

\item{Pars}{a matrix with 2 rows, each with P-spline parameters:
\code{min max nseg bdeg lambda pord}, for row and columns of tensor product surface; defaults are min and
max for \code{x_index} and \code{t_var} (resp.), \code{nseg} = 10, \code{bdeg} =3,
\code{lambda} = 1, \code{pord} = 2.}

\item{family}{the response distribution, e.g.
\code{"gaussian", "binomial", "poisson", "Gamma"} distribution; quotes are needed (default \code{"gaussian"}.}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"});
quotes are needed (default \code{"identity"}.}

\item{m_binomial}{a vector of binomial trials having \code{length(y)}. Default is 1 vector for \code{family = "binomial"}, NULL otherwise.}

\item{wts}{a \code{m} vector of weights (default 1).}

\item{r_gamma}{a vector of gamma shape parameters. Default is 1 vector for \code{family = "Gamma"}, NULL otherwise.}

\item{X_pred}{a matrix of signals with \code{ncol(X)} columns for prediction, default is \code{X}.}

\item{t_pred}{a vector for the VC indexing variable with length \code{nrow(X_pred)}, default is \code{t_var}.}

\item{y_predicted}{a vector for the responses associated with \code{X_pred}
with length \code{nrow(X_pred)} useful for CV when \code{family = "binomial"}, default is \code{NULL}.}

\item{ridge_adj}{a small ridge penalty tuning parameter to regularize estimation (default \code{1e-8}).}

\item{int}{intercept set to TRUE or FALSE for intercept term.}
}
\value{
\item{pcoef}{a vector of length \code{(Pars[1,3]+Pars[1,4])}*\code{(Pars[2,3]+Pars[2,4])}
of estimated P-spline coefficients for tensor surface.}
\item{summary_predicted}{inverse link prediction vectors, and twice se bands.}
\item{dev}{ the deviance of fit.}
\item{eff_dim}{the approximate effective dimension of fit.}
\item{family}{the family of the response.}
\item{link}{the link function.}
\item{aic}{AIC.}
\item{df_resid}{approximate df residual.}
\item{cv}{leave-one-out standard error prediction when \code{family = "gaussian"}, NULL otherwise.}
\item{cv_predicted}{standard error prediction for \code{y_predict} when \code{family = "gaussian"}, NULL otherwise.}
\item{Pars}{design and tuning parameters; see arguments above.}
\item{dispersion_parm}{estimate of dispersion, \code{Dev/df_resid}.}
\item{summary_predicted}{inverse link prediction vectors, and twice se bands.}
\item{eta_predicted}{estimated linear predictor of \code{length(y)}.}
\item{press_mu}{leave-one-out prediction of mean when \code{family = "gaussian"}, NULL otherwise.}
\item{bin_percent_correct}{percent correct classification based on 0.5 cut-off when \code{family = "binomial"}, NULL otherwise.}
\item{Bx}{B-spline basis matrix of dimension \code{p1} by \code{n1}, along \code{x_index}.}
\item{By}{B-spline basis matrix of dimension \code{p2} by \code{n2}, along \code{t_var}.}
\item{Q}{Modified tensor basis (\code{m} by \code{(n1*n2)}) for VC signal regression.}
\item{yint}{the estimated y-intercept (when \code{int = TRUE}.)}
\item{int}{a logical variable related to use of y-intercept in model.}
}
\description{
\code{psVCSignal} is used to regress a (glm) response onto a
 signal such that the signal coefficients can vary over another covariate \code{t}.
 Anisotripic penalization of tensor product B-splines produces a 2D coefficient surface that
 can be sliced at \code{t}.

 @details Support functions needed: \code{pspline_fitter}, \code{pspline_2dchecker},
 and \code{bbase}.

 @import stats
}
\examples{
library(fds)
data(nirc)
iindex <- nirc$x
X <- nirc$y
sel <- 50:650 # 1200 <= x & x<= 2400
X <- X[sel, ]
iindex <- iindex[sel]
dX <- diff(X)
diindex <- iindex[-1]
y <- as.vector(labc[1, 1:40]) # percent fat
t_var <- as.vector(labc[4, 1:40]) # percent flour
oout <- 23
dX <- t(dX[, -oout])
y <- y[-oout]
t_var = t_var[-oout]
Pars = rbind(c(min(diindex), max(diindex), 25, 3, 1e-7, 2),
c(min(t_var), max(t_var), 20, 3, 0.0001, 2))
fit1 <- psVCSignal(y, dX, diindex, t_var, Pars = Pars,
family = "gaussian", link = "identity", int = TRUE)
plot(fit1, xlab = "Coefficient Index", ylab = "VC: \% Flour")
names(fit1)
}
\references{
Eilers, P.H.C. and Marx, B.D. (2003). Multivariate calibration with temperature
interaction using two-dimensional penalized signal regression. \emph{Chemometrics
and Intellegent Laboratory Systems}, 66, 159–174.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
