% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{doevaluation}
\alias{doevaluation}
\title{doevaluation: compute the imputation KL-based scoring rules}
\usage{
doevaluation(
  imputations,
  methods,
  X.NA,
  m,
  num.proj,
  num.trees.per.proj,
  min.node.size,
  n.cores = 1,
  projection.function = NULL
)
}
\arguments{
\item{imputations}{a list of list of imputations matrices containing no missing values of the same size as X.NA}

\item{methods}{a vector of characters indicating which methods are considered for imputations. It should have the same length as the list imputations.}

\item{X.NA}{a matrix containing missing values, the data to impute.}

\item{m}{the number of multiple imputation to consider, defaulting to the number of provided multiple imputations.}

\item{num.proj}{an integer specifying the number of projections to consider for the score.}

\item{num.trees.per.proj}{an integer, the number of trees per projection.}

\item{min.node.size}{the minimum number of nodes in a tree.}

\item{n.cores}{an integer, the number of cores to use.}

\item{projection.function}{a function providing the user-specific projections.}
}
\value{
a vector made of the scores for each imputation method.
}
\description{
doevaluation: compute the imputation KL-based scoring rules
}
