% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Iscores.R
\name{Iscores}
\alias{Iscores}
\title{Iscores: compute the imputation KL-based scoring rules}
\usage{
Iscores(
  imputations,
  methods,
  X.NA,
  m = length(imputations[[1]]),
  num.proj = 100,
  num.trees.per.proj = 5,
  min.node.size = 10,
  n.cores = 1,
  projection.function = NULL,
  rescale = TRUE
)
}
\arguments{
\item{imputations}{a list of list of imputations matrices containing no missing values of the same size as X.NA}

\item{methods}{a vector of characters indicating which methods are considered for imputations. It should have the same length as the list imputations.}

\item{X.NA}{a matrix containing missing values, the data to impute.}

\item{m}{the number of multiple imputation to consider, defaulting to the number of provided multiple imputations.}

\item{num.proj}{an integer specifying the number of projections to consider for the score.}

\item{num.trees.per.proj}{an integer, the number of trees per projection.}

\item{min.node.size}{the minimum number of nodes in a tree.}

\item{n.cores}{an integer, the number of cores to use.}

\item{projection.function}{a function providing the user-specific projections.}

\item{rescale, }{a boolean, TRUE if the scores should be rescaled such that the max score is 0.}
}
\value{
a vector made of the scores for each imputation method.
}
\description{
Iscores: compute the imputation KL-based scoring rules
}
\examples{
n <- 100
X <- cbind(rnorm(n),rnorm(n))
X.NA <- X
X.NA[,1] <- ifelse(stats::runif(n)<=0.2, NA, X[,1])

imputations <- list()

imputations[[1]] <- lapply(1:5, function(i) {
 X.loc <- X.NA
 X.loc[is.na(X.NA[,1]),1] <- mean(X.NA[,1],na.rm=TRUE)
 return(X.loc)
})

imputations[[2]] <- lapply(1:5, function(i) {
 X.loc <- X.NA
 X.loc[is.na(X.NA[,1]),1] <- sample(X.NA[!is.na(X.NA[,1]),1],
 size = sum(is.na(X.NA[,1])), replace = TRUE)
 return(X.loc)
})

methods <- c("mean","sample")

Iscores(imputations,
methods,
X.NA,
num.proj=5
)

}
