% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{resamplingLocalI}
\alias{resamplingLocalI}
\title{Calculates n permutations of the variable of interest to calculate n different I in order to create the \eqn{Null} distribution.}
\usage{
resamplingLocalI(varOfInterest, distM, n = 1000, scaling = TRUE)
}
\arguments{
\item{varOfInterest}{the variable name  or position of the variable we are interested to calculate the spatial autocorrelation.}

\item{distM}{the distance matrix. Although the equation requires a weighted distant matrix, the only parameter that will be needed is the distance matrix. This procedure is able to calculate the weighted distance matrix by itself.}

\item{n}{number of permutations.}

\item{scaling}{The default value is TRUE. However, if the values are previously scaled, this parameter must be set to FALSE..}
}
\value{
A vector with the n calculated Local Moran's I.
}
\description{
\code{resamplingLocalI} Permute n-1 times the values of the variable of interest to calculate a Null distribution for I. It is done n-1, because one order is the original one, to make sure it is included.
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
vI<-resamplingLocalI(input$varOfInterest,distM,n=100)
}
