% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-rbind.R
\name{rbind}
\alias{rbind}
\alias{rbind,IntervalListOrIntervalMatrix-method}
\title{Combine \code{IntervalList} and \code{IntervalMatrix} objects by rows}
\usage{
\S4method{rbind}{IntervalListOrIntervalMatrix}(..., deparse.level = 1)
}
\arguments{
\item{...}{A sequence of lists or matrices of nonempty compact real intervals
stored as \code{IntervalList} or \code{IntervalMatrix} objects,
respectively.}

\item{deparse.level}{Currently not used (put here to match the signature of
the base implementation).}
}
\value{
This function returns a matrix of interval-valued
data stored as an \code{IntervalMatrix} object.
}
\description{
This function allows to combine a sequence of lists and matrices of
intervals, that is, \code{IntervalList} and \code{IntervalMatrix} objects, by
rows, and store the result as an \code{IntervalMatrix} instance.
}
\examples{
## Some rbind() examples
list1 <- IntervalList(c(0, 3), c(4, 5))
list2 <- IntervalList(c(3, 0), c(7, 4))
rbind(list1, list2)

matrix1 <- IntervalMatrix(matrix(c(0, 1, 2, 3, 0, 3, 4, 9), 2, 4))
matrix2 <- IntervalMatrix(matrix(c(1, 5, 2, 6, 0, 1, 2, 3), 2, 4))
rbind(matrix1, matrix2)

rbind(list1, matrix1)
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
