% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{iscamtwopropztest}
\alias{iscamtwopropztest}
\title{Two Proportion Z-Test and Interval}
\usage{
iscamtwopropztest(
  observed1,
  n1,
  observed2,
  n2,
  hypothesized = 0,
  alternative = NULL,
  conf.level = NULL,
  datatable = NULL,
  verbose = TRUE
)
}
\arguments{
\item{observed1}{The observed number of successes in group 1. If a value less than 1 is
provided, it is assumed to be the sample proportion.}

\item{n1}{The sample size for group 1.}

\item{observed2}{The observed number of successes in group 2. If a value less than 1 is
provided, it is assumed to be the sample proportion.}

\item{n2}{The sample size for group 2.}

\item{hypothesized}{The hypothesized difference in probability of success under the null
hypothesis. This is an optional parameter.}

\item{alternative}{A character string specifying the form of the alternative
hypothesis. Must be one of "less", "greater", or "two.sided". This is
an optional parameter.}

\item{conf.level}{The confidence level(s) for a two-sided confidence
interval. This is an optional parameter.}

\item{datatable}{A two-way table of counts as an alternative input method.
This is an optional parameter.}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
This function prints the results of the two-proportion z-test and/or
the confidence interval. It also generates plots to visualize the test and
interval.
}
\description{
iscamtwopropztest calculates a two-proportion z-test and/or a corresponding
confidence interval.
}
\examples{
iscamtwopropztest(observed1 = 35, n1 = 50, observed2 = 28, n2 = 45)

iscamtwopropztest(
  observed1 = 0.8,
  n1 = 100,
  observed2 = 0.6,
  n2 = 80,
  hypothesized = 0,
  alternative = "greater",
  conf.level = 0.95
)

iscamtwopropztest(observed1 = 60, n1 = 100, observed2 = 45, n2 = 90, conf.level = 0.90)
}
