% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_chart.R
\name{nested_chart}
\alias{nested_chart}
\title{Nested Chart}
\usage{
nested_chart(
  data,
  cd_method = "aggregate",
  test_order = NULL,
  facet_order = NULL,
  xarrows = TRUE,
  subradius = 0,
  file_name = "none",
  size = 1,
  relative_scaling = 0,
  font = "sans",
  rotate_radians = 0,
  rotate_degrees = 0,
  subrotate_radians = 0,
  subrotate_degrees = 0,
  file_width = 10,
  file_height = 10,
  zoom_x = NULL,
  zoom_y = NULL,
  dpi = 500,
  color_global = "#11C1FF",
  color_nested = "#007AD6",
  fade = 85,
  cor_spacing = 0,
  tick = 0,
  rotate_tick_label = 0,
  dist_construct_label = 10,
  rotate_construct_label_radians = 0,
  rotate_construct_label_degrees = 0,
  dist_test_labels = 2/3,
  rotate_test_labels_radians = 0,
  rotate_test_labels_degrees = 0,
  cor_labels_tests = TRUE,
  cor_labels_facets = TRUE,
  title = NULL,
  size_title = 1,
  size_construct_label = 1,
  size_test_labels = 1,
  size_facet_labels = 1,
  width_axes = 1,
  width_axes_inner = 1,
  width_circles = 1,
  width_circles_inner = 1,
  width_tick = 1,
  width_tick_inner = 1,
  size_tick_label = 1,
  size_cor_labels = 1,
  size_cor_labels_inner = 1,
  width_xarrows = 1,
  size_xarrow_heads = 1,
  size_xarrow_labels = 1,
  size_marker = 0.1,
  size_marker_inner = 0.05
)
}
\arguments{
\item{data}{Object of class IPV as created by the function 'ipv_est'}

\item{cd_method}{character; method to summarize center distances, either
"mean" or "aggregate", see details; defaults to "aggregate".}

\item{test_order}{character; vector of test names in desired order
(counter-clockwise); defaults to NULL, in which case the order is based on
the correlation matrix columns in 'data'.}

\item{facet_order}{character; vector of all facet names of all tests in
desired order (counter-clockwise); defaults to NULL, in which case the order
is based on the correlation matrix columns in 'data'.}

\item{xarrows}{logical; should arrows between tests be displayed?; defaults to
TRUE.}

\item{subradius}{integer; same unit as center distances; radius of the facet
circles; defaults to 0, in which case an appropriate value is estimated.}

\item{file_name}{character; name of the file to save. Supported formats are:
"pdf" (highest quality and smallest file size), "png", "jpeg"; defaults to
"none".}

\item{size}{integer; changes the size of most chart objects simultaneously.}

\item{relative_scaling}{integer; relative size of the global chart scale
compared to the nested facet chart scales; defaults to 0, in which case an
appropriate value is estimated.}

\item{font}{character; text font, use extrafonts to access additional fonts;
defaults to "sans", which is "Helvetica".}

\item{rotate_radians}{integer; radian angle to rotate the chart
counter-clockwise by; use fractions of pi (e.g. pi/2 = 90 degrees).}

\item{rotate_degrees}{integer; angle in degrees to rotate the chart
counter-clockwise by.}

\item{subrotate_radians}{integer; radian angle or vector of radian angles to
rotate the nested facet charts counter-clockwise by; use fractions of pi
(e.g. pi/2 = 90 degrees).}

\item{subrotate_degrees}{integer; angle or vector of angles in degrees to
rotate the nested facet charts counter-clockwise by.}

\item{file_width}{integer; file width in inches; defaults to 10.}

\item{file_height}{integer; file height in inches; defaults to 10.}

\item{zoom_x}{integer; vector with two values, the edges of the zoomed section
on the x-axis; defaults to NULL.}

\item{zoom_y}{integer; vector with two values, the edges of the zoomed section
on the y-axis; defaults to NULL.}

\item{dpi}{integer; resolution in dots per inch for "png" and "jpeg" files;
defaults to 500.}

\item{color_global}{global accent color; defaults to light blue ("#11C1FF").}

\item{color_nested}{nested accent color; defaults to blue ("#007AD6").}

\item{fade}{integer; brightness of the gray tones between 0 (black) and 100
(white) in steps of 1; defaults to 85.}

\item{cor_spacing}{integer; if \code{correlations = TRUE}: width of the ring,
the correlations between tests are drawn in; defaults to 0, in which case an
appropriate value is estimated.}

\item{tick}{numeric; axis tick position; defaults to 0, in which case an
appropriate value is estimated.}

\item{rotate_tick_label}{numeric; number of positions to move the tick label
(counter-clockwise); defaults to 0.}

\item{dist_construct_label}{integer; position of the construct label relative
to the surrounding circle; defaults to 10, in which case an appropriate
value is estimated; a value of .5 would position the label halfway between
the center and the surrounding circle.}

\item{rotate_construct_label_radians}{integer; radian angle to rotate the
construct label counter-clockwise by; use fractions of pi (e.g. pi/2 = 90
degrees).}

\item{rotate_construct_label_degrees}{integer; angle in degrees to rotate the
construct label counter-clockwise by.}

\item{dist_test_labels}{integer; position of the test labels relative to the
surrounding circle; defaults to 2/3, in which case the test labels are
displayed 2/3 of the way from the centers to the surrounding circles.}

\item{rotate_test_labels_radians}{integer; radian angle or vector of radian
angles to rotate the test labels counter-clockwise by; use fractions of pi
(e.g. pi/2 = 90 degrees).}

\item{rotate_test_labels_degrees}{integer; angle or vector of angle in degrees
to rotate the test labels counter-clockwise by.}

\item{cor_labels_tests}{logical; if \code{TRUE}, shows the correlations
between tests as text.}

\item{cor_labels_facets}{logical; if \code{TRUE}, shows the correlations
between facets as text.}

\item{title}{character; overall chart title; defaults to NULL.}

\item{size_title}{integer; title font size relative to default.}

\item{size_construct_label}{integer; construct label font size relative to
default.}

\item{size_test_labels}{integer; test label font size relative to default.}

\item{size_facet_labels}{integer; facet label font size relative to default.}

\item{width_axes}{integer; global radial axis width relative to default.}

\item{width_axes_inner}{integer; nested radial axis width relative to default.}

\item{width_circles}{integer; global circle outline width relative to default.}

\item{width_circles_inner}{integer; nested circle outline width relative to
default.}

\item{width_tick}{integer; global axis tick line width relative to default.}

\item{width_tick_inner}{integer; nested axis tick line width relative to
default.}

\item{size_tick_label}{integer; axis tick label font size relative to default.}

\item{size_cor_labels}{integer; font size of the correlations between tests
relative to default.}

\item{size_cor_labels_inner}{integer; font size of the correlations between
facets relative to default.}

\item{width_xarrows}{integer; extra arrow line width relative to default.}

\item{size_xarrow_heads}{integer; extra arrow head length relative to default.}

\item{size_xarrow_labels}{integer; font size of the correlations indicated by
extra arrows relative to default.}

\item{size_marker}{integer; size (in inches) of the value marker  at the
circle border that indicates the center distance, a value of 0 omits the
marker; defaults to .1}

\item{size_marker_inner}{integer; size (in inches) of the nested value marker
at the circle border that indicates the center distance, a value of 0 omits
the marker; defaults to .05}
}
\value{
Object of the class "ggplot".
}
\description{
Creates a nested chart, showing several tests and their facets.
}
\details{
To summarize center distances (\code{cd_method}), the "mean" method
 computes the average center distance (compute cds first, summarize across
 items second), while the "aggregate" method computes a center distance based
 on the sum of the squared loadings (summarize across items first, compute
 cds second). "Aggregate" (default) is recommended, because it is more
 meaningful in cases with heterogeneous factor loadings, while "mean" is the
 originally proposed method.

 To get tidy results, it is often required to use \code{rotate_} and
 \code{subrotate_} for better alignment.

 If you set \code{subrotate_} to a single value, all nested facet charts will
 be rotated by the same amount. If you use a vector of values, the nested
 facet charts will be rotated one by one by the values from that vector.

 Increase \code{relative_scaling} to avoid circle overlap. Decrease it to
 make small chart objects more visible.

 \code{correlations} and \code{cor_spacing} add larger circles around the
 nested facet charts, but do not change these facet charts.

 When changing the size of objects, consider the \code{size} parameter first
 and make specific adjustments with the other \code{size_} and \code{width_}
 parameters after.

 Pdf files will be vector based and can be scaled arbitrarily. For other
 formats use \code{file_width}, \code{file_height}, and \code{dpi} to avoid
 later rescaling and loss of quality.

 Instead of using screenshots to crop the chart, it is highly recommendable
 to use \code{zoom_x} and \code{zoom_y}. This allows for vector-based
 graphics quality when showing sections of the chart. With this cropping
 method, use \code{file_width} to set the overall size of the file output,
 \code{file_height} will automatically adjust to retain the correct aspect
 ratio, if both \code{zoom_x} and \code{zoom_y} are provided.

 If \code{facet1} or \code{facet2} is \code{NA} for a given xarrow, the arrow
 will end on the test's circle. Note: this correlation is usually not part of
 the model.

 Consider adding title and caption in your typesetting software (LaTeX, MS
 Word, ...), not here. The option to add a title is only a quick and dirty
 shurtcut. It reduces chart size and is inflexible. Adding the title manually
 will provide additional options, but requires you to save to a file
 manually. To manually add a title or caption use
 \code{\link[ggplot2]{labs}}.
}
\examples{
# as simple as that
nested_chart(self_confidence)

# rotating the nested facet charts one by one
nested_chart(self_confidence,
             subrotate_radians = c(0, pi/2, 0))

# test without facets

global <- system.file(
  "extdata", "IPV_global.xlsx", package = "IPV", mustWork = TRUE)
tests <- c(
  system.file("extdata", "IPV_DSSEI.xlsx", package = "IPV", mustWork = TRUE),
  system.file("extdata", "IPV_SMTQ.xlsx", package = "IPV", mustWork = TRUE),
  NA)
x <- input_excel(global = global, tests = tests)
nested_chart(x)

}
\seealso{
\code{\link{item_chart}} \code{\link{facet_chart}}
}
