% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_funcs.R
\name{staticConfMatrix}
\alias{staticConfMatrix}
\title{Confusion Matrix for Binary Classification Models}
\usage{
staticConfMatrix(list_models, t, reps = NULL, reps.all.unique = F)
}
\arguments{
\item{list_models}{A list of one (or more) dataframes for each model whose performance is to be evaluated. Each dataframe should comprise of 2 columns with the first column indicating the class labels (0 or 1)
and the second column providing the raw predicted probabilities}

\item{t}{Probability threshold value}

\item{reps}{Performance measures derived from the confusion matrix (Accuracy, TPR, FPR & Precision) are
computed for a range of different probability thresholds. The "reps" argument controls the number of
different probability thresholds considered (threshold range given by the sequence - seq(0,1,1/reps))}

\item{reps.all.unique}{Logical; If set to True, Performance measures are computed for each unique Probability value}
}
\value{
If reps = NULL, the output will be a list with 2 components - a confusion matrix
dataframe and a dataframe with the values of the computed metrics (Accuracy,TPR,FPR,Precision). If reps argument is supplied, an
additional dataframe containing the metrics values for different probability thresholds is
included in the output
}
\description{
Generates confusion matrix for a specified probability threshold. Also computes the
following metrics - Accuracy, True Positive Rate, False Positive Rate & Precision. Multiple models
can be passed as arguments to this function
}
\examples{
model_1 <- glm(Species ~ Sepal.Length,data=iris,family=binomial)
model_2 <- glm(Species ~ Sepal.Width, data=iris, family = binomial)
df1 <- data.frame(model_1$y,fitted(model_1))
df2 <- data.frame(model_2$y,fitted(model_2))
staticConfMatrix(list(df1,df2),t=0.2)
}

