% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coid.R
\encoding{UTF-8}
\name{coid}
\alias{coid}
\title{Correlation of degree of connector nodes}
\usage{
coid(
  network.or.subnet_mat1,
  subnet_mat2 = NULL,
  weighted = FALSE,
  weight_type = "shannon",
  method = "kendall"
)
}
\arguments{
\item{network.or.subnet_mat1}{An igraph object or matrix. An "igraph" object with node attribute 'level' or a matrix representing one subnetwork. See details.}

\item{subnet_mat2}{A matrix representing one subnetwork.}

\item{weighted}{Logical. Default to FALSE. If TRUE, the degree of a connector node is replaced with Shannon diversity or sum of its link strengths.}

\item{weight_type}{For weighted=TRUE only, supporting "shannon" or "sum".}

\item{method}{Correlation method ("pearson", "kendall" or "spearman"). Default to "kendall".}
}
\value{
Return a numeric value representing correlation of interaction degree for connector nodes.
}
\description{
Calculating correlation of degree of connector nodes.
}
\details{
In this package, a tripartite network contains three groups of nodes (a-nodes,b-nodes,c-nodes)  and two subnetworks (P includes the links between a-nodes and b-nodes, Q includes the links between b-nodes and c-nodes). Connector nodes belong to b-nodes.

This function follows Sauve et al.(2016) to calculate the correlation of interaction degree (or weighted degree ) of connector nodes. For the binary network, connector nodes' degree is calculated in each subnetwork.
For the quantitative network, Shannon diversity or sum of link strength for each connector node is calculated.
Three correlation methods are supported. Kendall correlation is recommended following Sauve et al.(2016).

Two types of inputs \code{network.or.subnet_mat1} can be processed:
\itemize{
\item An "igraph" object with node attribute 'level' (0 for a-nodes, 1 for b-nodes,2 for c-nodes). If the input is a weighted network, the edge should have a 'weight' attribute.
\item Or a matrix representing subnetwork P, and must be input with \code{subnet_mat2} representing subnetwork Q.
}

If the inputs are two matrices, please make sure the rows of
\code{network.or.subnet_mat1} and \code{subnet_mat2} both represent the groups of connector species,i.e, the b-group species. If both matrices have row names, then the function matches row
names to produce connector nodes. Otherwise, row numbers are assigned to row names and matched. Within the two matrices (P and Q), columns represents a-group nodes and c-group nodes respectively.
Elements in matrices are non-zero values if two nodes are linked with or without weights, and 0 otherwise.
}
\examples{

## generate a random binary tripartite network
set.seed(12)
Net <- build_toy_net(11,15,16,0.2)
coid(Net)

## empirical network
data(PPH_Coltparkmeadow)
Net <- PPH_Coltparkmeadow
coid(Net)
set.seed(13)
library(igraph)
E(Net)$weight<-runif(length(E(Net)),0.1,1)#random weights assigned
coid(Net,weighted=TRUE)

##input as binary matrices, with row names.
set.seed(12)
md1 <- matrix(sample(c(0,1),8*11,replace=TRUE),8,11,
       dimnames = list(paste0("b",1:8),paste0("c",1:11)))
md2 <- matrix(sample(c(0,1),10*12,replace=TRUE),10,12,
       dimnames = list(paste0("b",1:10),paste0("a",1:12)))
coid(md1,md2)

##input as weighted matrices,with row numbers as row names.
set.seed(12)
mdw1 <- matrix(sample(c(rep(0,40),runif(48,0,1))),8,11)
mdw2 <- matrix(sample(c(rep(0,40),runif(80,0,1))),10,12)
coid(mdw1,mdw2)
coid(mdw1,mdw2,weighted=TRUE)
coid(mdw1,mdw2,weighted=TRUE, weight_type="sum")
}
\references{
Sauve, A. M., Thebault, E., Pocock, M. J., & Fontaine, C. (2016). How plants connect pollination and herbivory networks and their contribution to community stability. Ecology, 97(4), 908-917.
}
