% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{mixture_sim}
\alias{mixture_sim}
\title{Simulation of a mixture of Gaussian distributions}
\usage{
mixture_sim(pct_clusters = c(0.5, 0.5), n = 500, p = 10, delta = 10)
}
\arguments{
\item{pct_clusters}{a vector of marginal probabilities for each group, i.e
mixture weights.
Default is two
balanced clusters.}

\item{n}{integer. The number of observations.}

\item{p}{integer. The number of variables.}

\item{delta}{integer. The location shift.}
}
\value{
A dataframe of \emph{n} observations and \emph{p+1} variables with the first
variable
indicating the cluster assignment using a character string.
}
\description{
Simulation of a \eqn{n \times p} data frame according to a mixture of \eqn{q}
Gaussian distributions with \eqn{q < p}, different location parameters
\eqn{\mu_1, \dots, \mu_q}, and the identity matrix as the covariance matrix.
}
\details{
Let \eqn{X} be a \eqn{p}-variate real random vector distributed according to
a mixture of \eqn{q} Gaussian distributions with \eqn{q < p},
different location parameters \eqn{\mu_1, \dots, \mu_q}, and the same positive
definite covariance matrix \eqn{I_p}:
\deqn{X \sim \sum_{h=1}^{q} \epsilon_h \, {\cal N}(\mu_h,I_p),}
where \eqn{\epsilon_{1}, \dots, \epsilon_{q}} are mixture weights with
\eqn{\epsilon_1 + \cdots + \epsilon_q = 1},  \eqn{\mu_1 = 0_p},
and  \eqn{\mu_{h+1} = \delta e_h} with \eqn{h = 1, \dots, q-1}.
}
\examples{
X <- mixture_sim()
summary(X)
}
\references{
Alfons, A., Archimbaud, A., Nordhausen, K., & Ruiz-Gazen, A. (2024).
Tandem clustering with invariant coordinate selection.
Econometrics and Statistics.
\doi{10.1016/j.ecosta.2024.03.002}.
}
\author{
Aurore Archimbaud
}
