# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Savitzky-Golay Filter for Matrix (Row-wise)
#'
#' Smooths each row of a matrix using a Savitzky-Golay filter.
#' @param x Matrix to smooth row-wise
#' @param window_size Size of the filter window (must be odd)
#' @param order Polynomial order
#' @param deriv Derivative order (0=smooth, 1=first deriv, etc.)
#' @param n_cores Number of cores to use
#' @export
sg_smooth_cpp <- function(x, window_size, order, deriv, n_cores = 1L) {
    .Call(`_ICEbox_sg_smooth_cpp`, x, window_size, order, deriv, n_cores)
}

#' Efficient Column Standard Deviations
#' 
#' @param x Numeric Matrix
#' @param n_cores Number of cores to use
#' @export
colSds_cpp <- function(x, n_cores = 1L) {
    .Call(`_ICEbox_colSds_cpp`, x, n_cores)
}

#' Row-wise Centering
#' 
#' Centers each row of a matrix by subtracting the row mean.
#' @param x Numeric Matrix
#' @param n_cores Number of cores to use
#' @export
rowCenter_cpp <- function(x, n_cores = 1L) {
    .Call(`_ICEbox_rowCenter_cpp`, x, n_cores)
}

#' Probability Transformation
#' 
#' Efficiently applies logodds or probit transformation to a matrix.
#' @param x Numeric Matrix (probabilities)
#' @param method 1 for centered logodds, 2 for probit
#' @param n_cores Number of cores to use
#' @export
transform_ice_curves_cpp <- function(x, method, n_cores = 1L) {
    .Call(`_ICEbox_transform_ice_curves_cpp`, x, method, n_cores)
}

#' Melt Matrix to Long Format Vector
#' 
#' Efficiently converts a matrix to a long-format vector (row-major order)
#' for plotting.
#' @param x Numeric Matrix
#' @param n_cores Number of cores to use
#' @export
melt_ice_curves_cpp <- function(x, n_cores = 1L) {
    .Call(`_ICEbox_melt_ice_curves_cpp`, x, n_cores)
}

#' Efficient Numerical Derivative for Matrix (Row-wise)
#' 
#' Computes the first derivative using centered differences, mirroring sfsmisc::D1tr.
#' @param x Numeric Matrix (smoothed values)
#' @param gridpts Grid points corresponding to columns of x
#' @param n_cores Number of cores to use
#' @export
derivative_cpp <- function(x, gridpts, n_cores = 1L) {
    .Call(`_ICEbox_derivative_cpp`, x, gridpts, n_cores)
}

