% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadMutectVCFs}
\alias{ReadMutectVCFs}
\title{Read Mutect VCF files.}
\usage{
ReadMutectVCFs(files, names.of.VCFs = NULL, tumor.col.names = NA)
}
\arguments{
\item{files}{Character vector of file paths to the VCF files.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order of
names in \code{names.of.VCFs} should match the order of VCF file paths in
\code{files}. If \code{NULL}(default), this function will remove all of the
path up to and including the last path separator (if any) in \code{files}
and file paths without extensions (and the leading dot) will be used as the
names of the VCF files.}

\item{tumor.col.names}{Vector of column names or column indices in VCFs which
contain the tumor sample information. The order of elements in
\code{tumor.col.names} should match the order of VCFs specified in
\code{files}. If \code{tumor.col.names} is equal to \code{NA}(default),
this function will use the 10th column in all the VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}
}
\description{
Read Mutect VCF files.
}
\section{Value}{
 A list of data frames which store data lines of VCF files
  with two additional columns added which contain the VAF(variant allele
  frequency) and read depth information.
}

\keyword{internal}
