% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions_lib.R
\name{GenerateWithinBounds}
\alias{GenerateWithinBounds}
\title{Constrained random numbers generator}
\usage{
GenerateWithinBounds(dist, par, n = 1, lowerBound = -Inf, higherBound = Inf)
}
\arguments{
\item{dist}{character, distribution name}

\item{par}{numeric vector, parameter vector}

\item{n}{integer, number of values to generate}

\item{lowerBound}{Numeric, lower bound}

\item{higherBound}{Numeric, higher bound, should be strictly larger than the lower bound}
}
\value{
The generated values as a numeric vector.
}
\description{
Generate random realizations from a distribution, 
constraining these realizations to stay within bounds.
}
\examples{
set.seed(123456)
y0=GenerateWithinBounds(dist='GEV',par=c(0,1,-0.2),n=1000)
y1=GenerateWithinBounds(dist='GEV',par=c(0,1,-0.2),n=1000,lowerBound=0,higherBound=5)
plot(y0);points(y1,col='red')
}
