% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_MTD_selection.R
\name{hybrid_MTD_selection}
\alias{hybrid_MTD_selection}
\title{Select the maximum tolerated dose (MTD) for single-agent dose-finding studies}
\usage{
hybrid_MTD_selection(target, dose, npts, nDLT, elimdose)
}
\arguments{
\item{target}{the target toxicity rate}

\item{dose}{a vector containing the numerical dosage of each dose level}

\item{npts}{a vector containing the number of patients treated at each dose level}

\item{nDLT}{a vector containing the number of patients who experienced dose-limiting
toxicity at each dose level}

\item{elimdose}{the dosage at the dose level which is excluded due to excessive toxicity}
}
\value{
The selected dosage as MTD
}
\description{
Select the maximum tolerated dose (MTD) when the single-agent dose-finding study is completed
}
\details{
\code{hybrid.MTD.selection()} selects the MTD based on isotonic estimates of toxicity
         probabilities. The isotonic estimates are obtained by the pooled-adjacent-violators
         algorithm (PAVA) (Barlow, 1972 <doi: 10.1080/01621459.1972.10481216>).
}
\note{
The dose levels above \code{elim} are all excluded for MTD selection.
}
\examples{
hybrid_MTD_selection(target=0.3, dose=c(2,4,8,16,22,28,40), npts=c(2,4,8,16,22,28,40),
                     nDLT=c(0,0,0,0,1,0,2), elimdose=28)

}
