% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc_audit_data.R
\name{preproc_audit_data}
\alias{preproc_audit_data}
\title{Audit daily data for total days in year}
\usage{
preproc_audit_data(
  data = NULL,
  Date,
  value,
  year_group,
  use_specific_years = FALSE,
  begin_year = NULL,
  end_year = NULL,
  days_cutoff = 360,
  date_format = "\%Y-\%m-\%d"
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'Date' or 'character' vector when \code{data = NULL}, or 'character' string identifying
Date column name when \code{data} is specified. Dates associated with each value in value parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying year column
name when \code{data} is specified. Values to audit, must be daily data.}

\item{year_group}{'numeric' vector when \code{data = NULL}, or 'character' string identifying
grouping column name when \code{data} is specified. Year grouping for each daily value in \code{value}
parameter. Must be same length as \code{value}.}

\item{use_specific_years}{'boolean' value. Flag to clip data to a certain set of years in
\code{year_group}. Default is \code{FALSE}.}

\item{begin_year}{'numeric' value. If \code{use_specific_years = TRUE}, beginning year to clip value.
Default is \code{NULL}.}

\item{end_year}{'numeric' value. If \code{use_specific_years = TRUE}, ending year to clip value.
Default is \code{NULL}.}

\item{days_cutoff}{'numeric' value. Designating the number of days required for a year to be
counted as full. Default is \code{360}.}

\item{date_format}{'character' string. Format of Date. Default is \code{"\%Y-\%m-\%d"}.}
}
\value{
A data.frame with \code{year_group}, count (n, excluding \code{NA} values)
of days in each \code{year_group}, and a complete years 'boolean' flag.
}
\description{
Audit daily data for total days in year. An audit is performed to inventory and
flag missing days in daily data and help determine if further analyses are appropriate.
}
\details{
Year grouping is commonly water year, climate year, or calendar year.
}
\examples{
preproc_audit_data(
  data = example_preproc, Date = "Date", value = "value", year_group = "WY"
)

}
\seealso{
\code{\link{preproc_fill_daily}}, \code{\link{preproc_precondition_data}}
}
\keyword{preprocessing-data}
