% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_annual_flow_stats.R
\name{calc_annual_flow_stats}
\alias{calc_annual_flow_stats}
\title{Calculate annual flow statistics from daily data}
\usage{
calc_annual_flow_stats(
  data = NULL,
  Date,
  year_group,
  Q,
  Q3 = NA_real_,
  Q7 = NA_real_,
  Q30 = NA_real_,
  jd = NA_integer_,
  calc_high = FALSE,
  calc_low = FALSE,
  calc_percentiles = FALSE,
  calc_monthly = FALSE,
  calc_WSCVD = FALSE,
  longitude = NA,
  calc_ICVD = FALSE,
  zero_threshold = 33,
  quantile_type = 8,
  na.action = c("na.omit", "na.pass")
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date},\cr
\code{year_group}, \code{Q}, and \verb{Q3, Q7, Q30, jd} (if required). Column names are specified as strings
in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'Date' or 'character' vector when \code{data = NULL}, or character' string identifying
Date column name when \code{data} is specified. Date associated with each value in \code{Q} parameter.}

\item{year_group}{'numeric' vector when \code{data = NULL}, or 'character' string identifying
grouping column name when \code{data} is specified. Year grouping for each daily value in \code{Q}
parameter. Must be same length as \code{Q} parameter. Often \code{year_group} is water year or climate
year.}

\item{Q}{'numeric' vector when \code{data = NULL}, or 'character' string identifying streamflow values
column name when \code{data} is specified. Daily streamflow data. Must be same length as \code{year_group}.}

\item{Q3}{'numeric' vector when \code{data = NULL}, or 'character' string identifying Q3 column name
when \code{data} is specified. 3-day moving average of daily streamflow data \code{Q} parameter, often
returned from \code{\link{preproc_precondition_data}}. Default is \code{NA_real_}, required if \code{calc_high} or
\code{calc_low = TRUE}. If specified, must be same length as \code{Q} parameter.}

\item{Q7}{'numeric' vector when \code{data = NULL}, or 'character' string identifying Q7 column name
when \code{data} is specified. 7-day moving average of daily streamflow data \code{Q} parameter, often
returned from \code{\link{preproc_precondition_data}}. Default is \code{NA_real_}, required if \code{calc_high} or
\code{calc_low = TRUE}. If specified, must be same length as \code{Q} parameter.}

\item{Q30}{'numeric' vector when \code{data = NULL}, or 'character' string identifying Q30 column name
when \code{data} is specified. 30-day average of daily streamflow data \code{Q} parameter, often returned
from \code{\link{preproc_precondition_data}}. Default is \code{NA_real_}, required if \code{calc_high} or
\code{calc_low = TRUE}. If specified, must be same length as \code{Q} parameter.}

\item{jd}{'numeric' vector when \code{data = NULL}, or 'character' string identifying jd column name
when \code{data} is specified. Calendar Julian day of daily streamflow data \code{Q} parameter, often
returned from \code{\link{preproc_precondition_data}}. Default is \code{NA_integer_}, required if \code{calc_high},
\code{calc_low}, \code{calc_WSCVD} or \code{calc_ICVD = TRUE}. If specified, must be same length as \code{Q}
parameter.}

\item{calc_high}{'boolean' value. Calculate high flow statistics for years in \code{year_group}.
Default is \code{FALSE}. See \strong{Details} for more information.}

\item{calc_low}{'boolean' value. Calculate low flow statistics for years in \code{year_group}.
Default is \code{FALSE}. See \strong{Details} for more information.}

\item{calc_percentiles}{'boolean' value. Calculate percentiles for years in \code{year_group}.
Default is \code{FALSE}. See \strong{Details} for more information.}

\item{calc_monthly}{'boolean' value. Calculate monthly statistics for years in \code{year_group}.
Default is \code{FALSE}. See \strong{Details} for more information.}

\item{calc_WSCVD}{'boolean' value. Calculate winter-spring center volume date for years in
\code{year_group}. Default is \code{FALSE}. See \strong{Details} for more information.}

\item{longitude}{'numeric' value. Site longitude in North American Datum of 1983 (NAD83),
required in WSCVD calculation. Default is \code{NA}. See \strong{Details} for more information.}

\item{calc_ICVD}{'boolean' value. Calculate inverse center volume date for years in \code{year_group}.
Default is \code{FALSE}. See \strong{Details} for more information.}

\item{zero_threshold}{'numeric' value as percentage. The percentage of years of a statistic that
need to be zero in order for it to be deemed a zero flow site for that statistic. For use in
trend calculation. See \strong{Details} on attributes. Default is \code{33} (33 percent) of the
annual statistic values.}

\item{quantile_type}{'numeric' value. The distribution type used in the \code{\link[stats:quantile]{stats::quantile}}
function. Default is \code{8} (median-unbiased regardless of distribution). Other
types common in hydrology are \code{6} (Weibull) or \code{9} (unbiased for normal distributions).}

\item{na.action}{'character' string indicating na.action passed to \code{\link[stats:aggregate]{stats::aggregate}}
\code{na.action} parameter. Default is \code{"na.omit"}, which removes \code{NA} values before aggregating
statistics, or \code{"na.pass"}, which will pass \code{NA} values and return \code{NA} in the grouped calculation
if any \code{NA} values are present.}
}
\value{
A tibble (see \code{\link[tibble:tibble]{tibble::tibble}}) with annual statistics depending on options selected.
See \strong{Details}.
}
\description{
Calculate annual flow statistics from daily data
}
\details{
\code{year_group} is commonly water year, climate year, or calendar year.\cr

Default annual statistics returned:
\describe{
\item{\code{annual_mean}}{annual mean in \code{year_group}}
\item{\code{annual_sd}}{annual standard deviation in \code{year_group}}
\item{\code{annual_sum}}{annual sum in \code{year_group}}
}

If \code{calc_high/low} are selected, annual statistics returned:\cr
1-, 3-, 7-, and 30-day high/low and Julian date (jd) of n-day high/low.
\describe{
\item{\code{high_q}\emph{n}}{where \emph{n} = 1, 3, 7, and 30}
\item{\code{high_q}\emph{n}\verb{_jd}}{where \emph{n} = 1, 3, 7, and 30}
\item{\code{low_q}\emph{n}}{where \emph{n} = 1, 3, 7, and 30}
\item{\code{low_q}\emph{n}\verb{_jd}}{where \emph{n} = 1, 3, 7, and 30}
}

If \code{calc_percentiles} is selected, annual statistics returned:\cr
1, 5, 10, 25, 50, 75, 90, 95, 99 percentile based on daily streamflow.
\describe{
\item{\code{annual_}\emph{n}\verb{_percentile}}{where \emph{n} = 1, 5, 10, 25, 50, 75, 90, 95, and 99}
}

If \code{calc_monthly} is selected, annual statistics returned:\cr
Monthly mean, standard deviation, max, min, percent of annual for each month in \code{year_group}.
\describe{
\item{\emph{month}\verb{_mean}}{monthly mean, where \emph{month} = \code{\link{month.abb}}}
\item{\emph{month}\verb{_sd}}{monthly standard deviation, where \emph{month} = \code{\link{month.abb}}}
\item{\emph{month}\verb{_max}}{monthly maximum, where \emph{month} = \code{\link{month.abb}}}
\item{\emph{month}\verb{_min}}{monthly minimum, where \emph{month} = \code{\link{month.abb}}}
\item{\emph{month}\verb{_percent_annual}}{monthly percent of annual, where \emph{month} = \code{\link{month.abb}}}
}

If \code{calc_WSCVD} is selected, Julian date of annual winter-spring center volume date is returned.\cr
Longitude (in NAD83 datum) is used to determine the ending month of spring. July for longitudes
West of \eqn{-}95 degrees, May for longitudes east of \eqn{-}95 degrees. See \strong{References}
Dudley and others, 2017. Commonly calculated when \code{year_group} is water year.
\describe{
\item{\code{WSCVD}}{Julian date of winter-spring center volume}
}

If \code{calc_ICVD} is selected, Julian date of annual inverse center volume date is returned.\cr
Commonly calculated when \code{year_group} is climate year.
\describe{
\item{\code{ICVD}}{Julian date of inverse center volume date}
}

\strong{Attribute:} \code{zero_flow_years}\cr
A data.frame with each annual statistic calculated, the percentage of years where the
statistic = 0, a flag indicating if the percentage is over the \code{zero_threshold} parameter,
and the number of years with a zero value. Columns in \code{zero_flow_years}:
\describe{
\item{\code{annual_stat}}{annual statistic}
\item{\code{percent_zeros}}{percentage of years with 0 statistic value}
\item{\code{over_threshold}}{boolean if percentage is over threshold}
\item{\code{number_years}}{number of years with 0 value statistic}
}
The \code{zero_flow_years} attribute can be useful in trend calculation, where a trend may not be
appropriate to calculate with many zero flow years.
}
\examples{
calc_annual_flow_stats(data = example_preproc, Date = "Date", year_group = "WY", Q = "value")

}
\references{
Dudley, R.W., Hodgkins, G.A, McHale, M.R., Kolian, M.J., Renard, B., 2017, Trends in
snowmelt-related streamflow timing in the conterminous United States: Journal of Hydrology, v.
547, p. 208-221. [Also available at https://doi.org/10.1016/j.jhydrol.2017.01.051.]
}
\seealso{
\code{\link{preproc_precondition_data}}
}
\keyword{annual-statistics}
