% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR_deseasonalize.R
\name{POR_deseasonalize}
\alias{POR_deseasonalize}
\title{Removes seasonal trends from a daily or monthly time series.}
\usage{
POR_deseasonalize(data = NULL, Date, value, time_step = c("daily", "monthly"))
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'numeric' vector of Dates corresponding to each \code{value} when \code{data = NULL}, or\cr
'character' string identifying Date column name when \code{data} is specified.}

\item{value}{'numeric' vector of values (often streamflow) when \code{data = NULL}, or\cr
'character' string identifying value column name when \code{data} is specified.\cr
(assumed to be daily or monthly).}

\item{time_step}{'character' value. Either \code{"daily"} or \code{"monthly"}.}
}
\value{
Deseasonalized values.
}
\description{
Removes seasonal trends from a daily or monthly time series. Daily data are
deseasonalized by subtracting monthly mean values. Monthly data are deseasonalized by
subtracting mean monthly values.
}
\details{
The deseasonalize function removes seasonal trends from a daily or monthly time series
and returns a deseasonalized time series, which can be used in the \code{\link{POR_calc_AR1}} function.
}
\examples{
POR_deseasonalize(data = example_obs, Date = "Date", value = "streamflow_cfs")

}
\seealso{
\code{\link{POR_calc_AR1}}
}
\keyword{period-of-record}
\keyword{preprocessing-data}
