% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR_calc_amp_and_phase.R
\name{POR_calc_amp_and_phase}
\alias{POR_calc_amp_and_phase}
\title{Calculate the seasonal amplitude and phase of a daily time series}
\usage{
POR_calc_amp_and_phase(
  data = NULL,
  Date,
  value,
  time_step = c("daily", "monthly")
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'numeric' vector of Dates corresponding to each \code{value} when \code{data = NULL}, or
'character' string identifying Date column name when \code{data} is specified.}

\item{value}{'numeric' vector of values (often streamflow) when \code{data = NULL}, or 'character'
string identifying value column name when \code{data} is specified. Assumed to be daily or monthly.}

\item{time_step}{'character' value. Either \code{"daily"} or \code{"monthly"}, Default is \code{"daily"}.}
}
\value{
A data.frame with calculated seasonal amplitude and phase
}
\description{
Calculates the  seasonal amplitude and phase of a daily time series.
}
\examples{
POR_calc_amp_and_phase(data = example_obs, Date = "Date", value = "streamflow_cfs")

}
\references{
Farmer, W.H., Archfield, S.A., Over, T.M., Hay, L.E., LaFontaine, J.H., and Kiang, J.E., 2014,
A comparison of methods to predict historical daily streamflow time series in the southeastern
United States: U.S. Geological Survey Scientific Investigations Report 2014–5231, 34 p.
[Also available at https://doi.org/10.3133/sir20145231.]
}
\keyword{period-of-record}
