% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FakePatientsDB.R
\name{create_fake_subjectDB}
\alias{create_fake_subjectDB}
\title{Create a fake subject database}
\usage{
create_fake_subjectDB(
  n_subjects = 100,
  n_facilities = 10,
  avg_n_stays = 3,
  days_since_discharge = NULL,
  length_of_stay = NULL,
  start_id_subjects = 1,
  start_id_facilities = 1,
  with_errors = FALSE
)
}
\arguments{
\item{n_subjects}{the number of different subjects in the database}

\item{n_facilities}{the number of facility present in the database}

\item{avg_n_stays}{the average number of stays per subject}

\item{days_since_discharge}{the number of days between a discharge date and an admission date (default: max(0, rnorm(1, mean = 30, sd = 10)))}

\item{length_of_stay}{the length of stay (default: max(1, rnorm(1, mean = 5, sd = 3) )}

\item{start_id_subjects, start_id_facilities}{change starting ids (used for clustered network)}

\item{with_errors}{(boolean) introduce or not random errors in the database. Default to FALSE.}
}
\value{
a data.table containing all subjects stays
}
\description{
Create a fake subject database
}
\examples{
mydb <- create_fake_subjectDB(n_subjects = 100, n_facilities = 10)
mydb
}
