% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSummary.R
\name{all_admissions_summary}
\alias{all_admissions_summary}
\title{Summary statistics on entire database}
\usage{
all_admissions_summary(base, verbose = FALSE, ...)
}
\arguments{
\item{base}{(data.table).
A subject discharge database, in the form of a data.table. The data.table should have at least the following columns:
    sID: subjectID (character)
    fID: facilityID (character)
    Adate: admission date (date)
    Ddate: discharge date (date)}

\item{verbose}{(boolean) print diagnostic messages. Default is TRUE.}

\item{...}{other parameters passed on to internal functions}
}
\value{
a list of summary statistics:
        -   meanLOS: The mean length of stay, in days
        -   meanTBA: The mean time between admissions, in days
        -   totalAdmissions: Total number of admissions (i.e. number of records in the database)
        -   numSubjects: Number of unique subjects
        -   numFacilities: Number of unique facilities
        -   LOSdistribution: Distribution of length of stay
        -   TBAdistribution: Distribution of time between admissions
}
\description{
Function that extracts summary statistics from entire database
}
\examples{
mydb <- create_fake_subjectDB(n_subjects = 100, n_facilities = 10)
myBase <- checkBase(mydb)
all_admissions_summary(myBase)
}
