% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bed.R
\name{read_bed}
\alias{read_bed}
\title{Read bed file}
\usage{
read_bed(file, extra_col_names = c(), length = FALSE, verbose = TRUE)
}
\arguments{
\item{file}{bed file}

\item{extra_col_names}{list of strings specifying extra column names}

\item{length}{boolean of whether to add length column}

\item{verbose}{boolean set to see function behavior}
}
\value{
tibble
}
\description{
Reads in a tab-delimited BED formatted file into R.
}
\details{
First three columns of file must be the genomic coordinates of the regions (i.e. chr start end).

read_bed will auto-detect BED3 and BED6 formats. It will also detect BED3+ and BED6+ formats assigning generic or user-defined col_names to the additional column(s).
}
\examples{
#load external data.
BED3 <- system.file(package = "HodgesTools", "extdata", "test_BED3.bed")
BED6 <- system.file(package = "HodgesTools", "extdata", "test_BED6.bed")
BED4 <- system.file(package = "HodgesTools", "extdata", "test_BED4.bed")
BED8 <- system.file(package = "HodgesTools", "extdata", "test_BED8.bed")

# Read 3-column BED file.
read_bed(BED3)

# Read 6-column BED file.
read_bed(BED6)

# Read 3-column BED file and add length column.
read_bed(BED3, length = TRUE)

# Read 3 column format BED file with additional fourth column. Add generic column names.
read_bed(BED4)

# Read 3 column format BED file with additional fourth column. Specify additional column names.
read_bed(BED4, extra_col_names = c("fourthColumn"))

# Read 6 column format BED file with additional columns. Specify additional column names.
read_bed(BED8, extra_col_names = c("seventhColumn", "eigthColumn"))

}
\author{
Tyler Hansen & Tim Scott
}
