% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_haplotypes.R
\name{define_haplotypes}
\alias{define_haplotypes}
\title{Define Haplotypes}
\usage{
define_haplotypes(
  vcf,
  LD,
  epsilon = 0.6,
  MGmin = 30,
  hetmiss_as = "allele",
  keep_outliers = FALSE
)
}
\arguments{
\item{vcf}{A VCF file.}

\item{LD}{A LD matrix file.}

\item{epsilon}{Affects haplotype size. It is a parameter of the DBSCAN clustering tool. The default is 0.6.}

\item{MGmin}{The minimum number of SNPs within a cluster for it to be defined as a haplotype.The default is 30.}

\item{hetmiss_as}{Affects how missing data is handled for all instances where one allele in a genotype is missing.If hetmiss_as = "allele" the genotype is assumed to be heterozygous. If hetmiss_as = "miss" the genotype is treated as NA.}

\item{keep_outliers}{If FALSE, removes SNPs that are determined to be outliers.}
}
\value{
A list of haplotype tables.
}
\description{
This function requires a VCF and an LD matrix.
It will then define local haplotypes and return a list of tables.
Each table within the list represents one haplotype.
These haplotype tables display the SNP genotypes within the haplotype.
}
