% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stat_dependency.R
\name{add_stat_dependency}
\alias{add_stat_dependency}
\title{Calculates confidence limits}
\usage{
add_stat_dependency(
  calc_dat,
  confidence_limit = 0.98,
  theoretical = FALSE,
  relative = TRUE
)
}
\arguments{
\item{calc_dat}{processed data from DynamX file - using \code{\link{prepare_dataset}}}

\item{confidence_limit}{confidence limit chosen by user - from range [0, 1].}

\item{theoretical}{logical value to determine if the plot is theoretical or not.}

\item{relative}{logical value to determine if values are relative or absolute.}
}
\value{
calc_dat extended by column specifying if given peptide is relevant in given confidence limit. 
The value of the confidence limit is added as an attribute - as well as parameters used to calculate (theoretical/relative)
}
\description{
Returns relation with confidence limits for each peptide.
}
\details{
...
}
\examples{
#load example data
dat <- read_hdx(system.file(package = "HaDeX", 
                            "HaDeX/data/KD_180110_CD160_HVEM.csv"))
                            
# prepate dataset for states `CD160` and `CD160_HVEM` in given time parameters 
calc_dat <- prepare_dataset(dat,
                            in_state_first = "CD160_0.001",
                            chosen_state_first = "CD160_1",
                            out_state_first = "CD160_1440",
                            in_state_second = "CD160_HVEM_0.001",
                            chosen_state_second = "CD160_HVEM_1",
                            out_state_second = "CD160_HVEM_1440") 
                            
# add calculated confidence limits for prepared data
add_stat_dependency(calc_dat, 
                    confidence_limit = 0.98, 
                    theoretical = FALSE, 
                    relative = TRUE)
                     

}
\seealso{
\code{\link{read_hdx}} \code{\link{prepare_dataset}}
}
