% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_fischenich2000.R
\name{n_fischenich2000}
\alias{n_fischenich2000}
\title{Compute hydraulic roughness due to vegetation following Fischenich (2000)}
\usage{
n_fischenich2000(
  depth,
  hp,
  seperate = TRUE,
  Cd = 0,
  Ad = 0,
  CdAd = 0,
  restrict = TRUE
)
}
\arguments{
\item{depth}{flow depth (H) in meters. Assumes wide channel geometry where depth
is approximately equal to hydraulic radius.}

\item{hp}{vegetation height (h_p) in meters. Vegetation is emergent.}

\item{seperate}{Allows user to choose whether to use separate (Cd and Ad) or
combined (CdAd). Type boolean. Default TRUE.}

\item{Cd}{stand drag coefficient (C_d), default 0}

\item{Ad}{vegetation area based on density (A_d), default 0}

\item{CdAd}{Combined Cd and Ad values, default 0}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_fischenich2000} calculate Manning's n using the Fischenich (2000) method
for estimating vegetative roughness
}
\examples{
# Result: Manning's n of 0.100
n_fischenich2000(6,2,TRUE,0.955,0.755)

# Result: Manning's n of 0.059
n_fischenich2000(6,2,FALSE,CdAd=0.0199)

# Result: Manning's n of 0.090
n_fischenich2000(3,1,TRUE,0.1806,0.1662)

# Result: Depth must be positive.
n_fischenich2000(-1,1,TRUE,0.1806,0.1662)

}
\references{
Fischenich, J. C. 2000. Resistance due to Vegetation. ERDC TN-EMRRP-SR-07,
U.S. Army Engineer Research and Development Center, Vicksburg, Mississippi.

Fischenich, J. C., and S. Dudley. 2000. Determining Drag Coefficients and Area
for Vegetation. ERDC TNEMRRP-SR-08, U.S. Army Engineer Research and Development
Center, Vicksburg, Mississippi.
}
