% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTSeedGLM.R
\name{FStat}
\alias{FStat}
\title{F-test between two fitted models}
\usage{
FStat(model1, model2)
}
\arguments{
\item{model1}{First fitted model}

\item{model2}{Second fitted model}
}
\value{
\itemize{
  \item Degrees of freedom and p-value
}
}
\description{
This function considers two fitted models as inputs. Considering the first model as full model, it performs testing equality of uniformity parameters representing the model under null hypothesis and provides the p-value and degrees of freedom of the test statistic.
}
\examples{
data1 <- data.frame(cbind(sg = c(rep(1, 95), rep(0, 5), rep(1, 87), rep(0, 13),
rep(1, 80), rep(0, 20), rep(1, 59), rep(0, 41),
rep(1, 50), rep(0, 50), rep(1, 79), rep(0, 21),
rep(1, 69), rep(0, 31), rep(1, 72), rep(0, 28),
rep(1, 44), rep(0, 56), rep(1, 14), rep(0, 86)),
v1 = c(rep(1, 500), rep(0, 500)),
v2 = c(rep(0, 500), rep(1, 500)),
wp1 = c(rep(0, 100), rep(-0.3, 100), rep(-0.6, 100),
       rep(-0.9, 100), rep(-1.2, 100), rep(0, 500)),
wp2 = c(rep(0, 600), rep(-0.3, 100), rep(-0.6, 100),
       rep(-0.9, 100), rep(-1.2, 100))))
data2 <- data.frame(cbind(sg = c(rep(1, 95), rep(0, 5), rep(1, 87), rep(0, 13),
rep(1, 80), rep(0, 20), rep(1, 59), rep(0, 41),
rep(1, 50), rep(0, 50), rep(1, 79), rep(0, 21),
rep(1, 69), rep(0, 31), rep(1, 72), rep(0, 28),
rep(1, 44), rep(0, 56), rep(1, 14), rep(0, 86)),
v1 = c(rep(1, 500), rep(0, 500)),
v2 = c(rep(0, 500), rep(1, 500)),
wp = c(rep(0, 100), rep(-0.3, 100), rep(-0.6, 100),
      rep(-0.9, 100), rep(-1.2, 100), rep(0, 100),
      rep(-0.3, 100), rep(-0.6, 100), rep(-0.9, 100),
      rep(-1.2, 100))))
myprobit1 <- glm(sg ~ v1 + v2 + wp1 + wp2 - 1, data = data1, family = binomial(link = probit))
myprobit2 <- glm(sg ~ v1 + v2 + wp - 1, data = data2,
family = binomial(link = probit))
my.f<- FStat(myprobit1, myprobit2)
}
\references{
\itemize{
\item Bradford, K. J. (2002). Applications of Hydrothermal Time to Quantifying and Modeling Seed Germination and Dormancy. Weed Science, 50(2), 248–260. http://www.jstor.org/stable/4046371
\item Kebreab, E., & Murdoch, A. J. (1999). Modelling the effects of water stress and temperature on germination rate of Orobanche aegyptiaca seeds. Journal of Experimental Botany, 50(334), 655-664. doi:10.1093/jxb/50.334.655
\item Dobson, A. J., & Barnett, A. G. (2018). An introduction to generalized linear models. Chapman and Hall/CRC.
}
}
