% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HKSPOR.R
\name{HKSPOR}
\alias{HKSPOR}
\title{Inference method for any number K of regimes}
\usage{
HKSPOR(X, Y, deg, K, constraint = 1, EM = TRUE, TimeTrans_Prop = c(),
  plotG = TRUE)
}
\arguments{
\item{X}{A numerical vector corresponding to the explanatory variable. X must be sorted in ascending order
if this is not the case, X will be sorted in the function and the corresponding permutation will be applied to Y. The
user will be notified by a warning message. In addition, if X contains NAs, they will be deleted from the data and the user will be notified by a warning message.
Finally, if X contains duplicate data, the excess data will be deleted and the user will be notified by a warning message.}

\item{Y}{A numerical vector corresponding to the variable to be explain. It should contain at least two regimes that
could be modelled by polynomials. In addition, if Y contains NAs they will be deleted from the data and the
user will be notified by a warning message. Finally, if X contains dupplicate data, the excess data will be deleted and
the value of the remaining Y will become the average of the Ys, calculated for this value of X.}

\item{deg}{Degree of the polynomials. The size of X and Y must be greater than K(deg+2) + K.}

\item{K}{The number of regimes. The size of X and Y must be greater than K(deg+2) + K.}

\item{constraint}{Number that determines the regularity assumption that is applied for the parameters estimation.
By default, the variable is set to 1, i. e. the parameters estimation is done under continuity constraint.
If the variable is 0 or 2, the estimation of the parameters will be done without assumption of regularity
(constraint = 0) or under assumption of differentiability (constraint = 2). Warning, if the differentiability
assumption is not verified by the model, it is preferable not to use it to estimate the model parameters.
In addition, if the degree of the polynomials is equal to 1, you cannot use the differentiability assumption.}

\item{EM}{A Boolean. If EM is TRUE (default), then the function will estimate the parameters
of a latent variable polynomial regression model using an EM algorithm. If EM is FALSE then
the function will estimate the parameters of the initial polynomial regression model by a fixed point algorithm.}

\item{TimeTrans_Prop}{A numerical vector. This vector is empty by default. If you want to estimate
the model parameters for fixed jump time values, you can propose these values here.
Warning, the size of this vector must be equal to K-1.}

\item{plotG}{A Boolean. If TRUE (default) the estimation results obtained by the HKSPOR function are plotted.}
}
\value{
A dataframe which contains the estimated parameters of the polynomial regression model at
K regimes: the times of transition, the polynomials coefficients and the variances of the K regimes.
If plotG = TRUE, the data (X,Y) and the estimated model will be plotted.
}
\description{
HKSPOR is an inference method that estimates, under regularity constraint, the parameters of
a polynomial regression model for a number K of regimes given by the user.
}
\examples{

set.seed(3)
xgrid1 = seq(0,10,by=0.2)
xgrid2 = seq(10.2,20,by=0.2)
xgrid3 = seq(20.2,30,by=0.2)
ygrid1 = xgrid1^2-xgrid1+1+ rnorm(length(xgrid1),0,3)
ygrid2 = rep(91,length(xgrid2))+ rnorm(length(xgrid2),0,3)
ygrid3 = -10*xgrid3+300+rnorm(length(xgrid3),0,3)
xgrid = c(xgrid1,xgrid2,xgrid3)
ygrid = c(ygrid1,ygrid2,ygrid3)

#Inference of a polynomial regression model with three regimes on these data.
#The degree of the polynomials is fixed to 2 and the parameters are estimated
# under continuity constraint when the times of jump are fixed to 10 and 20.

HKSPOR(xgrid,ygrid,2,3,1,EM = FALSE,c(10,20))


\donttest{
set.seed(3)
xgrid1 = seq(0,10,by=0.2)
xgrid2 = seq(10.2,20,by=0.2)
xgrid3 = seq(20.2,30,by=0.2)
ygrid1 = xgrid1^2-xgrid1+1+ rnorm(length(xgrid1),0,3)
ygrid2 = rep(91,length(xgrid2))+ rnorm(length(xgrid2),0,3)
ygrid3 = -10*xgrid3+300+rnorm(length(xgrid3),0,3)
xgrid = c(xgrid1,xgrid2,xgrid3)
ygrid = c(ygrid1,ygrid2,ygrid3)

#Inference of a polynomial regression model with three regimes (K=3) on these data.
#The degree of the polynomials is fixed to 2 and the parameters are estimated
#under continuity constraint.
HKSPOR(xgrid,ygrid,2,3,1)
#Executed time : 49.70051 mins (intel core i7 processor)
}
}
