% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapfun.R
\name{bootstrapfun}
\alias{bootstrapfun}
\title{Bootstrap function for a  bivariate copula models}
\usage{
bootstrapfun(Q, family, tau, n, df, max_iter, eps, HMM)
}
\arguments{
\item{Q}{Weights vector (1 x reg or component);}

\item{family}{'gaussian' , 't' , 'clayton' , 'frank' , 'gumbel'}

\item{tau}{Kendall's rank correlation}

\item{n}{number of simulated vectors}

\item{df}{vector of degree of freedom (d x 1), only for the Student copula.}

\item{max_iter}{maximum number of iterations for estimation}

\item{eps}{precision (e.g 0.00001);}

\item{HMM}{1 (if HMM) , 0 (if mixture);}
}
\value{
\item{theta1}{Estimated copula parameters}

\item{Q1}{Estimated transition matrix}

\item{eta1}{Estimated probabilites for regimes}

\item{tau1}{Estimated Kendall's tau}

\item{dof1}{Estimated degrees of freedom for the Student copula}

\item{Usim}{Estimated pseudo-observations}

\item{cvm_sim}{Estimated Cramer-von Mises statistic}
}
\description{
Bootstrapping function needed for parallel computing
}
\author{
Mamadou Yamar Thioub and Bruno Remillard, April 12, 2018
}
\keyword{internal}
