% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_refined_anchored_lasso.R
\name{process_fold_mean_diff}
\alias{process_fold_mean_diff}
\title{Process one cross-validation fold for mean difference testing}
\usage{
process_fold_mean_diff(
  fold_index,
  control,
  treatment,
  control_split_index,
  tr_split_index,
  pca_method,
  classifier_method,
  lambda_type,
  group,
  verbose
)
}
\arguments{
\item{fold_index}{Integer index of the current fold.}

\item{control}{Matrix or data frame for the control group (rows = samples, columns = features).}

\item{treatment}{Matrix or data frame for the treatment group (rows = samples, columns = features).}

\item{control_split_index}{A list of row indices for each fold of the control group.}

\item{tr_split_index}{A list of row indices for each fold of the treatment group.}

\item{pca_method}{Character. PCA method to use. Options are \code{"dense_pca"} or \code{"sparse_pca"}.}

\item{classifier_method}{Character. Classifier method. Options are \code{"lasso"} or \code{"group_lasso"}.}

\item{lambda_type}{Character. Lambda selection method. Options are \code{"lambda.min"} or \code{"lambda.1se"}.}

\item{group}{Optional grouping vector for group lasso.}

\item{verbose}{Logical. Whether to print progress messages.}
}
\value{
A list containing the test statistic, its variance, scores for each group, the projection direction, and intermediate quantities.
}
\description{
Computes the test statistic, variance, and projection direction for one fold in a cross-validated comparison of two groups.
}
