% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_refined_anchored_lasso.R
\name{compute_predictive_contributions}
\alias{compute_predictive_contributions}
\title{Compute predictive contributions of feature groups}
\usage{
compute_predictive_contributions(result, group, group_threshold = 5)
}
\arguments{
\item{result}{A result object returned by \code{mean_comparison_anchor()}, containing \code{fold_data} with classifier coefficients.}

\item{group}{A grouping vector indicating group membership of features. Must be the same length as the number of features.}

\item{group_threshold}{Integer. Minimum number of active features required in a group for it to be considered active. Default is 5.}
}
\value{
A data frame with two columns:
\describe{
\item{group}{Group name or label.}
\item{score}{Proportion of total predictive signal attributable to that group.}
}
}
\description{
Analyzes the relative contribution of grouped features to the overall discriminant signal, based on averaged Lasso coefficients across cross-validation folds.
}
\details{
The function identifies active groups based on cross-validated non-zero coefficients, then decomposes the total L2 norm of the average coefficient vector across groups.
}
\seealso{
\code{\link{collect_active_features_proj}}
}
