% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_pre_processing_functions.R
\name{check_non_null_and_identical_colnames}
\alias{check_non_null_and_identical_colnames}
\title{Check non-null and consistent column names across datasets}
\usage{
check_non_null_and_identical_colnames(data_list)
}
\arguments{
\item{data_list}{A list of matrices or data frames to be checked.}
}
\value{
NULL (called for side-effect). Throws an error if validation fails.
}
\description{
Ensures all input datasets have non-null, non-empty, and identical column names.
}
\examples{
d1 <- data.frame(a = 1:2, b = 3:4)
d2 <- data.frame(a = 5:6, b = 7:8)
check_non_null_and_identical_colnames(list(d1, d2))

}
