% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\docType{package}
\name{HLMdiag}
\alias{HLMdiag-package}
\alias{HLMdiag}
\alias{package-HLMdiag}
\title{Diagnostic tools for hierarchical (multilevel) linear models}
\description{
HLMdiag provides a suite of diagnostic tools for hierarchical 
(multilevel) linear models fit using the \code{lme4} or \code{nlme}
packages. These tools are grouped below by purpose. 
See the help documentation for additional information
about each function.
}
\details{
\bold{Residual analysis}

HLMdiag's \code{\link{hlm_resid}} function provides a wrapper that 
extracts residuals and fitted values for individual observations
or groups of observations. In addition to being a wrapper function for functions
implemented in the \code{lme4} and \code{nlme} packages,
\code{\link{hlm_resid}} provides access to the marginal and least squares
residuals.

\bold{Influence analysis}

HLMdiag's \code{\link{hlm_influence}} function provides a convenient wrapper 
to obtain influence diagnostics for each observation or group of observations 
appended to the data used to fit the model. The diagnostics returned by 
\code{\link{hlm_influence}} include Cook's distance, MDFFITS, covariance trace (covtrace),
covariance ratio (covratio), leverage, and relative variance change (RVC). 
HLMdiag also contains functions to calculate these diagnostics individually, as discussed below. 

Influence on fitted values

HLMdiag provides \code{\link{leverage}} that calculates the influence
that observations/groups have on the fitted values (leverage). 
For mixed/hierarchical models leverage can be decomposed into two parts: the 
fixed part and the random part. We refer the user to the references
cited in the help documentation for additional explanation.

Influence on fixed effects estimates

HLMdiag provides \code{\link{cooks.distance}} and \code{\link{mdffits}}
to assess the influence of subsets of observations on the fixed effects.

Influence on precision of fixed effects

HLMdiag provides \code{\link{covratio}} and \code{\link{covtrace}}
to assess the influence of subsets of observations on the precision of
the fixed effects.

Influence on variance components

HLMdiag's \code{\link{rvc}} calculates the relative variance change to
assess the influence of subsets of observations on the variance
components.

\bold{Graphics}

HLMdiag also strives to make graphical assessment easier in the 
\code{ggplot2} framework by providing dotplots for influence diagnostics
(\code{\link{dotplot_diag}}), grouped Q-Q plots (\code{\link{group_qqnorm}}),
and Q-Q plots that combine the functionality of \code{\link{qqnorm}} and
\code{\link{qqline}} (\code{\link{ggplot_qqnorm}}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/aloy/HLMdiag}
  \item Report bugs at \url{https://github.com/aloy/HLMdiag/issues}
}

}
\author{
\strong{Maintainer}: Adam Loy \email{loyad01@gmail.com}

Authors:
\itemize{
  \item Jaylin Lowe
  \item Jack Moran
}

}
\keyword{package}
