% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S_TISP_Path.R
\name{S_TISP_Path}
\alias{S_TISP_Path}
\title{S_TISP_Path Function}
\usage{
S_TISP_Path(X, y, grps, k, index, lambdas)
}
\arguments{
\item{X}{A block diagonal design matrix.For each block, each row represents an observation. All blocks share the same number of columns.}

\item{y}{response vector whose length equals to the sum of number of observations across all groups.}

\item{grps}{a vector to indicate which group each entry of beta belongs}

\item{k}{number of groups}

\item{index}{a vector indicates the starting point and ending point for each group. For example, if there is 100 samples in the first group and 150 samples in the second group, then it is c(1,100,101,250)}

\item{lambdas}{a vector of tuning parameters of group lasso penalty}
}
\description{
This function allows you to obtain Estimation of high-dimensional 
multi-response regression with heterogeneous noises under 
eterogeneous group square-root Lasso penalty.
}
\examples{
p <- 10
n <- 20
k <- 2
X <- matrix(0, n*k, p*k)
X[1:n, 1:p] <- rnorm(n*p)
X[(n+1):(k*n), (p+1):(p*k)] <- rnorm(n*p)
beta <- c(0:9, (0:9)/2)
y <- X \%*\% beta + rnorm(n*k)*0.1
grps <- rep(1:p, k)
lambdas <- (1:5)/2
index <- c(1, n, n+1, 2*n)
betaest <- S_TISP_Path(X, y, grps, k, index, lambdas)
}
