\name{cv.HDtweedie}
\alias{cv.HDtweedie}
\title{Cross-validation for HDtweedie}
\description{Does k-fold cross-validation for HDtweedie, produces a plot,
and returns a value for \code{lambda}. This function is modified based on the \code{cv} function from the \code{glmnet} package.}
\usage{
cv.HDtweedie(x, y, group = NULL, p, weights, lambda = NULL, 
	pred.loss = c("deviance", "mae", "mse"), 
	nfolds = 5, foldid, ...)
}
\arguments{
\item{x}{matrix of predictors, of dimension \eqn{n \times p}{n*p}; each row is an observation vector.}
\item{y}{response variable. This argument should be non-negative.}
\item{group}{To apply the grouped lasso, it is a vector of consecutive integers describing the grouping of the coefficients (see example below). To apply the lasso, the user can ignore this argument, and the vector is automatically generated by treating each variable as a group.}
\item{p}{the power used for variance-mean relation of Tweedie model. Default is 1.50.}
		\item{weights}{the observation weights. Default is equal weight.}
		\item{lambda}{optional user-supplied lambda sequence; default is
		\code{NULL}, and \code{\link{HDtweedie}} chooses its own sequence.}
		\item{pred.loss}{loss to use for cross-validation error. Valid options are:
		\itemize{
		\item \code{"deviance"} Deviance. 
		\item \code{"mae"} Mean absolute error.
		\item \code{"mse"} Mean square error.
		}
		Default is \code{"deviance"}.}
		\item{nfolds}{number of folds - default is 5. Although \code{nfolds}
		can be as large as the sample size (leave-one-out CV), it is not
		recommended for large datasets. Smallest value allowable is \code{nfolds=3}.}
		\item{foldid}{an optional vector of values between 1 and \code{nfold}
		identifying what fold each observation is in. If supplied,
		\code{nfold} can be missing.}
		\item{\dots}{other arguments that can be passed to HDtweedie.}
}
\details{The function runs \code{\link{HDtweedie}} \code{nfolds}+1 times; the
first to get the \code{lambda} sequence, and then the remainder to
compute the fit with each of the folds omitted. The average error and standard deviation over the
folds are computed. 
}
\value{an object of class \code{\link{cv.HDtweedie}} is returned, which is a
list with the ingredients of the cross-validation fit.
		\item{lambda}{the values of \code{lambda} used in the fits.}
		\item{cvm}{the mean cross-validated error - a vector of length
		\code{length(lambda)}.}
		\item{cvsd}{estimate of standard error of \code{cvm}.}
		\item{cvupper}{upper curve = \code{cvm+cvsd}.}
		\item{cvlower}{lower curve = \code{cvm-cvsd}.}
		\item{name}{a text string indicating type of measure (for plotting
		purposes).}
		\item{HDtweedie.fit}{a fitted \code{\link{HDtweedie}} object for the full data.}
		\item{lambda.min}{The optimal value of \code{lambda} that gives minimum
		cross validation error \code{cvm}.}
		\item{lambda.1se}{The largest value of \code{lambda} such that error is
		within 1 standard error of the minimum.}
}

\author{Wei Qian, Yi Yang and Hui Zou\cr
Maintainer: Wei Qian  <weiqian@stat.umn.edu>}
\references{
Qian, W., Yang, Y., Yang, Y. and Zou, H. (2016), ``Tweedie's Compound
    Poisson Model With Grouped Elastic Net,'' \emph{Journal of Computational and Graphical Statistics}, 25, 606-625.\cr
}

\seealso{\code{\link{HDtweedie}}, \code{\link{plot.cv.HDtweedie}}, \code{\link{predict.cv.HDtweedie}}, and \code{\link{coef.cv.HDtweedie}} methods.}
\examples{
# load HDtweedie library
library(HDtweedie)

# load data set
data(auto)

# 5-fold cross validation using the lasso
cv0 <- cv.HDtweedie(x=auto$x,y=auto$y,p=1.5,nfolds=5) 

# define group index
group1 <- c(rep(1,5),rep(2,7),rep(3,4),rep(4:14,each=3),15:21)

# 5-fold cross validation using the grouped lasso 
cv1 <- cv.HDtweedie(x=auto$x,y=auto$y,group=group1,p=1.5,nfolds=5)
}
\keyword{models}
\keyword{regression}

