% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbSearchControl.R
\name{vbSearchControl}
\alias{vbSearchControl}
\title{Parameters for variable block structure search.}
\usage{
vbSearchControl(
  perm = NULL,
  numstPerDim = NULL,
  dim = NULL,
  maxDim = 10,
  minDim = 1,
  nperm = 1,
  relax = FALSE
)
}
\arguments{
\item{perm}{A list of integer vectors specifying variable permutations. If
provided, the argument \code{dim} must be supplied.}

\item{numstPerDim}{An integer vector of length \code{maxDim} specifying a map from
the variable block dimensionality to the number of states in the block. 
\emph{k}th value in the vector corresponds to number of states for dimensionality \emph{k}.}

\item{dim}{Data dimensionality. Must be provided with \code{perm} argument,
otherwise is ignored.}

\item{maxDim}{Maximum variable block dimension.}

\item{minDim}{Minimum variable block dimension. Should be an integer equal to 1 or 2.}

\item{nperm}{The number of variable permutations. This parameter is ignored 
if permutations are provided in \code{perm} argument.}

\item{relax}{A logical value indicating whether or not variable block structure search 
will be performed under less restricting conditions.}
}
\value{
The named list with parameters.
}
\description{
This function creates a list with parameters for the search of a variable 
block structure used as an argument for \code{hmmvbTrain}.
}
\examples{
# setting up permutations
perm <- list(c(1,2,3), c(1,3,2), c(3,2,1))
searchControl <- vbSearchControl(perm=perm, dim=3)

# setting up a map between block dimensionality and number of states
searchControl <- vbSearchControl(maxDim=5, numstPerDim=c(3,4,5,6,7))
}
\seealso{
\code{\link{hmmvbTrain}}
}
