% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SKK2013.TSBF.NABT.R
\name{SKK2013.TSBF.NABT}
\alias{SKK2013.TSBF.NABT}
\title{Normal-approximation-based test for two-sample BF problem proposed by Srivastava et al. (2013)}
\usage{
SKK2013.TSBF.NABT(y1, y2)
}
\arguments{
\item{y1}{The data matrix (\eqn{n_1 \times p}) from the first population. Each row represents a \eqn{p}-dimensional observation.}

\item{y2}{The data matrix (\eqn{n_2 \times p} from the second population. Each row represents a \eqn{p}-dimensional observation.}
}
\value{
A list of class \code{"NRtest"} containing the results of the hypothesis test. See the help file for \code{\link{NRtest.object}} for details.
}
\description{
Srivastava et al. (2013)'s test for testing equality of two-sample high-dimensional mean vectors without assuming that two covariance matrices are the same.
}
\details{
Suppose we have two independent high-dimensional samples:
\deqn{
\boldsymbol{y}_{i1},\ldots,\boldsymbol{y}_{in_i}, \;\operatorname{are \; i.i.d. \; with}\; \operatorname{E}(\boldsymbol{y}_{i1})=\boldsymbol{\mu}_i,\; \operatorname{Cov}(\boldsymbol{y}_{i1})=\boldsymbol{\Sigma}_i,i=1,2.
}
The primary object is to test
\deqn{H_{0}: \boldsymbol{\mu}_1 = \boldsymbol{\mu}_2\; \operatorname{versus}\; H_{1}: \boldsymbol{\mu}_1 \neq \boldsymbol{\mu}_2.}
Srivastava et al. (2013) proposed the following test statistic:
\deqn{T_{SKK} = \frac{(\bar{\boldsymbol{y}}_1 - \bar{\boldsymbol{y}}_2)^\top \hat{\boldsymbol{D}}^{-1}(\bar{\boldsymbol{y}}_1 - \bar{\boldsymbol{y}}_2) - p}{\sqrt{2 \widehat{\operatorname{Var}}(\hat{q}_n) c_{p,n}}},}
where \eqn{\bar{\boldsymbol{y}}_{i},i=1,2} are the sample mean vectors, \eqn{\hat{\boldsymbol{D}}=\hat{\boldsymbol{D}}_1/n_1+\hat{\boldsymbol{D}}_2/n_2} with \eqn{\hat{\boldsymbol{D}}_i,i=1,2} being the diagonal matrices consisting of only the diagonal elements of the sample covariance matrices. \eqn{\widehat{\operatorname{Var}}(\hat{q}_n)} is given by equation (1.18) in Srivastava et al. (2013), and  \eqn{c_{p, n}} is the adjustment coefficient proposed by Srivastava et al. (2013).
They showed that under the null hypothesis, \eqn{T_{SKK}} is asymptotically normally distributed.
}
\examples{
library("HDNRA")
data("COVID19")
dim(COVID19)
group1 <- as.matrix(COVID19[c(2:19, 82:87), ]) ## healthy group
group2 <- as.matrix(COVID19[-c(1:19, 82:87), ]) ## COVID-19 patients
SKK2013.TSBF.NABT(group1,group2)


}
\references{
\insertRef{Srivastava_2013}{HDNRA}
}
\concept{ts}
