% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffIM.R
\name{EffIM}
\alias{EffIM}
\title{Monitoring the trial at interim looks for a trial with efficacy monitoring only}
\usage{
EffIM(
  d2,
  dmax,
  last.look = FALSE,
  d1,
  etam,
  alpha,
  beta,
  opt = "OBF",
  param = 4
)
}
\arguments{
\item{d2}{vector of number of events at which you want to monitor the trial.}

\item{dmax}{maximum number of events in the experimental group calculated from design function.}

\item{last.look}{logical which indicates whether the current look is the last look or not. Default is FALSE. If true, the post hoc power is calculated.}

\item{d1}{total number of events in the historical control group.}

\item{etam}{value of the drift parameter obtained from design function.}

\item{alpha}{type I error.}

\item{beta}{type II error.}

\item{opt}{type of spending function: "OBF", "Gamma", "Rho" or "Pocock". Default is "OBF".}

\item{param}{Parameter for "gamma family" or rho family. Default value is 4.}
}
\value{
A list containing efficacy boundary values along with the p-values and transformed information time for the current look. Post-hoc power is also calculated in case of early stopping of the trial.
}
\description{
Calculates one-sided efficacy boundary values at the observed number of events.
}
\details{
The number of events have to be entered sequentially. See example.
}
\examples{
#Interim look for the trial when the number of events is 13(first look).
gg<-EffIM(c(13),dmax=57,alpha=0.05,beta=0.1,etam=3.0726,d1=65,opt="OBF",last.look=FALSE)
#Interim look for the trial when the number of events is 35(second look).
gg<-EffIM(c(13,35),dmax=57,alpha=0.05,beta=0.1,etam=3.0726,d1=65,opt="OBF",last.look=FALSE)
}
\references{
\insertRef{doi:10.1002/pst.1756}{HCTDesign}

\insertRef{doi:10.1080/10543406.2019.1684305}{HCTDesign}
}
\author{
Tushar Patni, Yimei Li and Jianrong Wu.
}
