% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shock_cal.R
\name{create_target_config}
\alias{create_target_config}
\title{Create Target Value Configuration}
\usage{
create_target_config(
  path = NULL,
  type = NULL,
  header = NULL,
  value_col = "Value"
)
}
\arguments{
\item{path}{Optional path to the target data file.}

\item{type}{Optional file type for the target dataset ("har", "sl4", "csv", or "xlsx").}

\item{header}{Optional header name within the HAR or SL4 file to extract.}

\item{value_col}{Column name containing numeric target values. Default is "Value".}
}
\value{
A list containing:
\itemize{
\item \code{path}: file path to target data
\item \code{type}: file format (lowercase)
\item \code{header}: header name in HAR/SL4 file
\item \code{value_col}: column name for target values
}
}
\description{
Defines the configuration for loading the target dataset, which represents
post-adjustment or comparative rate values. Supports multiple file formats.
}
\details{
\itemize{
\item Supports \code{HAR}, \code{SL4}, \code{CSV}, and \code{XLSX} file formats
\item Can also represent a uniform numeric target value when no file path is provided
\item Used in combination with \code{\link{create_initial_config}} for shock computation
}
}
\examples{
# Example: Define Target Configuration
target <- create_target_config(
  path   = "D:/Data/taxrates_2019.har",
  type   = "har",
  header = "rTMS"
)
}
\seealso{
\code{\link{create_initial_config}}, \code{\link{create_calc_config}},
\code{\link{shock_calculate}}, \code{\link{shock_calculate_uniform}}
}
\author{
Pattawee Puangchit
}
